package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.Xpp3Dom;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;

/**
 * An abstraction over different types of databases, for use when preparing the database for integration tests.
 */
public interface JiraDatabase {
    /**
     * Returns the datasource associated with this database.
     *
     * @return see description
     */
    @Nonnull
    DataSource getDataSource();

    /**
     * Returns the configuration for the <code>sql-maven-plugin</code> to drop and recreate this database.
     *
     * @return see description
     */
    @Nonnull
    Xpp3Dom getSqlMavenCreateConfiguration() throws MojoExecutionException;

    /**
     * Returns the configuration for the <code>sql-maven-plugin</code> to import an SQL dump file into this database.
     *
     * @return see description
     */
    @Nonnull
    Xpp3Dom getSqlMavenFileImportConfiguration();

    /**
     * Returns the dependencies necessary for the <code>sql-maven-plugin</code> to operate on this database.
     *
     * @return see description
     */
    @Nonnull
    List<Dependency> getSqlMavenDependencies();

    /**
     * Returns the configuration for the <code>exec-maven-plugin</code> to import data into this database using a
     * vendor-specific tool.
     *
     * @return <code>null</code> if this database doesn't use such a tool (e.g. uses SQL statements)
     */
    @Nullable
    Xpp3Dom getExecMavenToolImportConfiguration() throws MojoExecutionException;
}
