/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.LibArtifact;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractJiraDatabase
implements JiraDatabase {
    protected final DataSource dataSource;
    protected final Log log;
    protected LibArtifact lib;

    protected AbstractJiraDatabase(DataSource dataSource, Log log) {
        this.dataSource = Objects.requireNonNull(dataSource);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    @Nonnull
    public final DataSource getDataSource() {
        return this.dataSource;
    }

    protected abstract String dropDatabase() throws MojoExecutionException;

    protected abstract String createDatabase() throws MojoExecutionException;

    protected abstract String dropUser();

    protected abstract String createUser();

    protected abstract String grantPermissionForUser() throws MojoExecutionException;

    protected Xpp3Dom systemDatabaseConfiguration() {
        return MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("driver"), this.dataSource.getDriver()), MojoExecutor.element(MojoExecutor.name("url"), this.dataSource.getDefaultDatabase()), MojoExecutor.element(MojoExecutor.name("username"), this.dataSource.getSystemUsername()), MojoExecutor.element(MojoExecutor.name("password"), this.dataSource.getSystemPassword()), MojoExecutor.element(MojoExecutor.name("autocommit"), "true"));
    }

    protected Xpp3Dom productDatabaseConfiguration() {
        return MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("driver"), this.dataSource.getDriver()), MojoExecutor.element(MojoExecutor.name("url"), this.dataSource.getUrl()), MojoExecutor.element(MojoExecutor.name("username"), this.dataSource.getUsername()), MojoExecutor.element(MojoExecutor.name("password"), this.dataSource.getPassword()), MojoExecutor.element(MojoExecutor.name("autocommit"), "true"));
    }

    protected abstract String getDatabaseName(String var1) throws MojoExecutionException;

    @Override
    @Nonnull
    public List<Dependency> getSqlMavenDependencies() {
        if (this.dataSource.getLibArtifacts() == null) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (LibArtifact libArtifact : this.dataSource.getLibArtifacts()) {
            Dependency dependency = new Dependency();
            dependency.setGroupId(libArtifact.getGroupId());
            dependency.setArtifactId(libArtifact.getArtifactId());
            dependency.setVersion(libArtifact.getVersion());
            dependencies.add(dependency);
        }
        return dependencies;
    }

    @Override
    @Nonnull
    public Xpp3Dom getSqlMavenFileImportConfiguration() {
        Xpp3Dom pluginConfiguration = this.productDatabaseConfiguration();
        pluginConfiguration.addChild(MojoExecutor.element(MojoExecutor.name("srcFiles"), MojoExecutor.element(MojoExecutor.name("srcFile"), this.dataSource.getDumpFilePath())).toDom());
        return pluginConfiguration;
    }

    @Override
    public Xpp3Dom getExecMavenToolImportConfiguration() throws MojoExecutionException {
        return null;
    }
}

