package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import org.apache.maven.plugin.logging.Log;

import javax.annotation.Nonnull;
import java.util.Optional;

import static com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseType.getDatabaseType;
import static java.util.Objects.requireNonNull;

/**
 * A factory for {@link JiraDatabase} instances.
 */
public class JiraDatabaseFactory {
    private final Log log;

    /**
     * Constructor.
     *
     * @param log the Maven logger
     */
    public JiraDatabaseFactory(@Nonnull final Log log) {
        this.log = requireNonNull(log);
    }

    /**
     * Returns the {@link JiraDatabase} for the given {@link DataSource}.
     *
     * @param dataSource the data source
     * @return empty if the database can't be obtained
     */
    @Nonnull
    public Optional<JiraDatabase> getJiraDatabase(final DataSource dataSource) {
        return getDatabaseType(dataSource)
                .flatMap(dbType -> dbType.getJiraDatabase(dataSource, log));
    }
}
