/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

@ParametersAreNonnullByDefault
public final class ProductHandlerUtil {
    private static final X509TrustManager PERMISSIVE_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] certificates, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certificates, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };

    private ProductHandlerUtil() {
        throw new UnsupportedOperationException("Do not implement");
    }

    public static List<ProductArtifact> toArtifacts(@Nullable String val) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return new ArrayList<ProductArtifact>();
        }
        return Arrays.stream(val.split(",")).map(artifact -> {
            String[] items = artifact.split(":");
            if (items.length < 2 || items.length > 3) {
                throw new IllegalArgumentException("Invalid artifact pattern: " + artifact);
            }
            String groupId = items[0].trim();
            String artifactId = items[1].trim();
            String version = items.length == 3 ? items[2].trim() : "LATEST";
            return new ProductArtifact(groupId, artifactId, version);
        }).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortFree(int requestedPort, @Nullable InetAddress bindAddress) {
        try (ServerSocket ignored = new ServerSocket(requestedPort, 1, bindAddress);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isPortFree(int requestedPort) {
        return ProductHandlerUtil.isPortFree(requestedPort, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int pickFreePort(int requestedPort, @Nullable InetAddress bindAddress) {
        try (ServerSocket socket = new ServerSocket(requestedPort, 1, bindAddress);){
            int n = requestedPort == 0 ? socket.getLocalPort() : requestedPort;
            return n;
        }
        catch (IOException e) {
            if (requestedPort != 0) return ProductHandlerUtil.pickFreePort(0, bindAddress);
            throw new IllegalStateException("Error opening socket", e);
        }
    }

    public static int pickFreePort(int requestedPort) {
        return ProductHandlerUtil.pickFreePort(requestedPort, null);
    }

    public static void awaitStateChange(Product product, Node node, boolean startingUp, Log log) throws MojoExecutionException {
        int port = node.getWebPort();
        if (port != 0) {
            String startStop = startingUp ? "start" : "stop";
            String url = product.getProtocol() + "://" + product.getServer() + ":" + port + StringUtils.defaultString((String)product.getContextPath(), (String)"");
            int timeout = product.getTimeout(startingUp);
            long end = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
            URL urlToPing = ProductHandlerUtil.toUrl(url);
            Optional<SSLFactoryAndVerifier> previousHttpsConfig = ProductHandlerUtil.configureSslConnection(product, startStop, url, timeout);
            String lastMessage = "";
            boolean success = false;
            HttpURLConnection connection = null;
            while (System.nanoTime() < end) {
                try {
                    connection = (HttpURLConnection)urlToPing.openConnection();
                    int response = connection.getResponseCode();
                    lastMessage = "Last response code is " + response;
                    success = startingUp == response < 400;
                }
                catch (Exception e) {
                    lastMessage = e.getMessage();
                    boolean bl = success = !startingUp;
                }
                if (!success && !ProductHandlerUtil.sleepInterrupted(url, log, startStop)) continue;
            }
            ProductHandlerUtil.closeInputStream(connection);
            previousHttpsConfig.ifPresent(SSLFactoryAndVerifier::apply);
            if (!success) {
                throw new MojoExecutionException(String.format("The product %s didn't %s after %ds at %s. %s", product.getInstanceId(), startStop, TimeUnit.MILLISECONDS.toSeconds(timeout), url, lastMessage));
            }
        }
    }

    private static boolean sleepInterrupted(String url, Log log, String startStop) {
        log.info((CharSequence)("Waiting for " + url + " to " + startStop));
        try {
            TimeUnit.SECONDS.sleep(1L);
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
    }

    private static void closeInputStream(@Nullable HttpURLConnection connection) {
        if (connection != null) {
            try {
                connection.getInputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static Optional<SSLFactoryAndVerifier> configureSslConnection(Product product, String startStop, String url, int timeout) throws MojoExecutionException {
        try {
            return ProductHandlerUtil.configureConnection(product.getUseHttps());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new MojoExecutionException(String.format("The product %s didn't %s after %ds at %s. %s", product.getInstanceId(), startStop, TimeUnit.MILLISECONDS.toSeconds(timeout), url, e.getMessage()));
        }
    }

    private static URL toUrl(String url) throws MojoExecutionException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private static Optional<SSLFactoryAndVerifier> configureConnection(boolean useHttps) throws NoSuchAlgorithmException, KeyManagementException {
        if (!useHttps) {
            return Optional.empty();
        }
        HostnameVerifier previousHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        SSLSocketFactory previousSslSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        TrustManager[] trustManagers = new TrustManager[]{PERMISSIVE_TRUST_MANAGER};
        sslContext.init(null, trustManagers, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier((s, sslSession) -> sslSession != null);
        return Optional.of(new SSLFactoryAndVerifier(previousHostnameVerifier, previousSslSocketFactory));
    }

    private static class SSLFactoryAndVerifier {
        private final HostnameVerifier verifier;
        private final SSLSocketFactory sslSocketFactory;

        public SSLFactoryAndVerifier(HostnameVerifier verifier, SSLSocketFactory factory) {
            this.verifier = Objects.requireNonNull(verifier);
            this.sslSocketFactory = Objects.requireNonNull(factory);
        }

        public void apply() {
            HttpsURLConnection.setDefaultSSLSocketFactory(this.sslSocketFactory);
            HttpsURLConnection.setDefaultHostnameVerifier(this.verifier);
        }
    }
}

