/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.XmlOverride;
import com.atlassian.maven.plugins.amps.database.DatabaseType;
import com.atlassian.maven.plugins.amps.database.DatabaseTypeFactory;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.product.JavaModulePackage;
import com.atlassian.maven.plugins.amps.product.common.ValidationException;
import com.atlassian.maven.plugins.amps.product.common.XMLDocumentHandler;
import com.atlassian.maven.plugins.amps.product.common.XMLDocumentProcessor;
import com.atlassian.maven.plugins.amps.product.jira.config.DatabaseTypeUpdaterTransformer;
import com.atlassian.maven.plugins.amps.product.jira.config.DbConfigValidator;
import com.atlassian.maven.plugins.amps.product.jira.config.SchemeUpdaterTransformer;
import com.atlassian.maven.plugins.amps.product.manager.WebAppManager;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.atlassian.maven.plugins.amps.util.JvmArgsFix;
import com.atlassian.maven.plugins.amps.util.ProductHandlerUtil;
import com.atlassian.maven.plugins.amps.util.PropertyUtils;
import com.atlassian.maven.plugins.amps.util.VersionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.repository.RepositorySystem;

public class JiraProductHandler
extends AbstractWebappProductHandler {
    @VisibleForTesting
    static final String INSTALLED_PLUGINS_DIR = "installed-plugins";
    @VisibleForTesting
    static final String PLUGINS_DIR = "plugins";
    @VisibleForTesting
    static final String BUNDLED_PLUGINS_UNZIPPED = "WEB-INF/atlassian-bundled-plugins";
    @VisibleForTesting
    static final String BUNDLED_PLUGINS_FROM_4_1 = "WEB-INF/classes/atlassian-bundled-plugins.zip";
    @VisibleForTesting
    static final String BUNDLED_PLUGINS_UPTO_4_0 = "WEB-INF/classes/com/atlassian/jira/plugin/atlassian-bundled-plugins.zip";
    @VisibleForTesting
    static final String FILENAME_DBCONFIG = "dbconfig.xml";
    private static final String JIRADS_PROPERTIES_FILE = "JiraDS.properties";
    private static final String JIRA_HOME_PLACEHOLDER = "${jirahome}";
    private static final String SERVER_ID_PATTERN = "'[A-B]{1}[A-Z0-9]{3}-[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{4}'";

    public JiraProductHandler(MavenContext context, MavenGoals goals, RepositorySystem repositorySystem, ArtifactResolver artifactResolver, WebAppManager webAppManager) {
        super(context, goals, new JiraPluginProvider(), repositorySystem, artifactResolver, webAppManager);
    }

    @Override
    @Nonnull
    public String getId() {
        return "jira";
    }

    @Override
    @Nonnull
    public String getDefaultContainerId() {
        return "tomcat7x";
    }

    @Override
    public int getDefaultHttpPort() {
        return 2990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8442;
    }

    @Override
    @Nonnull
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.jira", "atlassian-jira-webapp", "RELEASE");
    }

    @Override
    @Nonnull
    public Optional<ProductArtifact> getTestResourcesArtifact() {
        return Optional.of(new ProductArtifact("com.atlassian.jira.plugins", "jira-plugin-test-resources"));
    }

    @Override
    @Nonnull
    protected Collection<String> getExtraJarsToSkipWhenScanningForTldsAndWebFragments() {
        return ImmutableList.of((Object)"jotm*.jar", (Object)"xapool*.jar");
    }

    @Override
    protected void processHomeDirectory(Product product, int nodeIndex, File homeDir) throws MojoExecutionException {
        super.processHomeDirectory(product, nodeIndex, homeDir);
        if (product.isMultiNode()) {
            if (nodeIndex == 0) {
                JiraProductHandler.setUpSharedHome(product, homeDir.getParent());
            }
            JiraProductHandler.createClusterPropertiesFile(product, nodeIndex, homeDir);
        }
        JiraProductHandler.createDbConfigXmlIfNone(homeDir);
        this.updateDbConfigXmlFromDataSource(product, homeDir);
    }

    @Override
    @Nonnull
    protected List<File> getConfigFiles(@Nonnull Product product, @Nonnull File homeDir) {
        List<File> configFiles = super.getConfigFiles(product, homeDir);
        configFiles.add(new File(homeDir, "database.log"));
        configFiles.add(new File(homeDir, "database.script"));
        configFiles.add(new File(homeDir, FILENAME_DBCONFIG));
        return configFiles;
    }

    @Override
    @Nonnull
    protected List<ConfigFileUtils.Replacement> getReplacements(@Nonnull Product product, int nodeIndex) {
        String contextPath = product.getContextPath();
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        String baseUrl = product.getProtocol() + "://" + product.getServer() + ":" + product.getWebPortForNode(nodeIndex) + contextPath;
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(product, nodeIndex);
        replacements.add(0, new ConfigFileUtils.Replacement("http://localhost:8080", baseUrl, false));
        replacements.add(new ConfigFileUtils.Replacement("@project-dir@", this.getProjectDir(product), false));
        replacements.add(new ConfigFileUtils.Replacement("/jira-home/", "/home/", false));
        replacements.add(new ConfigFileUtils.Replacement("@base-url@", baseUrl, false));
        replacements.add(new ConfigFileUtils.RegexReplacement(SERVER_ID_PATTERN, "''"));
        return replacements;
    }

    @Override
    @Nonnull
    protected Optional<File> getUserInstalledPluginsDirectory(Product product, File webappDir, File homeDir) {
        File pluginHomeDirectory = JiraProductHandler.getPluginHomeDirectory(product, homeDir);
        return Optional.of(new File(new File(pluginHomeDirectory, PLUGINS_DIR), INSTALLED_PLUGINS_DIR));
    }

    @Override
    @Nonnull
    protected File getBundledPluginPath(Product product, File productDir) {
        File bundleDir = new File(productDir, BUNDLED_PLUGINS_UNZIPPED);
        if (bundleDir.exists() && bundleDir.isDirectory()) {
            return bundleDir;
        }
        String bundledPluginPluginsPath = BUNDLED_PLUGINS_FROM_4_1;
        String[] version = product.getVersion().split("-", 2)[0].split("\\.");
        try {
            long minor;
            long major = Long.parseLong(version[0]);
            long l = minor = version.length > 1 ? Long.parseLong(version[1]) : 0L;
            if (major < 4L || major == 4L && minor == 0L) {
                bundledPluginPluginsPath = BUNDLED_PLUGINS_UPTO_4_0;
            }
        }
        catch (NumberFormatException e) {
            this.log.debug((CharSequence)String.format("Unable to parse Jira version '%s', assuming Jira 4.1 or newer.", product.getVersion()), (Throwable)e);
        }
        return new File(productDir, bundledPluginPluginsPath);
    }

    @Override
    protected void customiseInstance(Product product, File homeDir, File explodedWarDir) {
        if (new ComparableVersion(product.getVersion()).compareTo(new ComparableVersion("7.12.0")) >= 0) {
            product.setCargoXmlOverrides(JiraProductHandler.serverXmlJiraOverride());
        }
    }

    @Override
    protected void fixJvmArgs(Product product) {
        JvmArgsFix argsFix = JvmArgsFix.empty().withAddOpens(ADD_OPENS_FOR_TOMCAT).withAddOpens(ADD_OPENS_FOR_FELIX).withAddOpens(JavaModulePackage.fromJavaBaseModule("java.lang.reflect")).withAddOpens(JavaModulePackage.fromJavaBaseModule("java.time")).withAddOpens(JavaModulePackage.fromJavaBaseModule("java.util")).withAddOpens(JavaModulePackage.fromJavaBaseModule("java.util.concurrent.atomic")).withAddOpens(JavaModulePackage.fromJavaBaseModule("sun.reflect.generics.parser")).withAddOpens(JavaModulePackage.fromJavaBaseModule("sun.security.action")).withAddOpens(JavaModulePackage.fromJavaBaseModule("sun.util.calendar")).withAddOpens(JavaModulePackage.fromJavaDesktopModule("sun.font")).withAddOpens(JavaModulePackage.fromJavaManagementModule("javax.management")).withAddOpens(JavaModulePackage.fromJavaXmlModule("jdk.xml.internal")).withAddOpens(JavaModulePackage.fromJdkManagementModule("com.sun.management.internal"));
        ComparableVersion productVersion = new ComparableVersion(product.getVersion());
        if (productVersion.compareTo(new ComparableVersion("8.0.0-ALPHA")) >= 0) {
            product.setJvmArgs(argsFix.with("-Xmx", "2g").with("-Xms", "1g").apply(product.getJvmArgs()));
        } else if (productVersion.compareTo(new ComparableVersion("7.7.0-ALPHA")) >= 0) {
            product.setJvmArgs(argsFix.with("-Xmx", "768m").with("-Xms", "384m").apply(product.getJvmArgs()));
        } else {
            super.fixJvmArgs(product);
        }
    }

    @Override
    protected DataSource getDefaultDataSource(Product product) {
        return this.getDataSourceFromJiraDSFile(product).orElse(this.getHsqlDataSource(product));
    }

    @Override
    @Nonnull
    protected Map<String, String> getProductSpecificSystemProperties(Product product, int nodeIndex) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        String homeDirectory = FileUtils.fixWindowsSlashes(this.getHomeDirectories(product).get(nodeIndex).getPath());
        properties.put((Object)"jira.home", (Object)homeDirectory);
        properties.put((Object)"cargo.servlet.uriencoding", (Object)"UTF-8");
        if (product.isAwaitFullInitialization()) {
            properties.put((Object)"com.atlassian.jira.startup.LauncherContextListener.SYNCHRONOUS", (Object)"true");
        }
        return properties.build();
    }

    @Override
    @Nonnull
    protected List<ProductArtifact> getExtraContainerDependencies(Product product, File productFile) {
        return Arrays.asList(new ProductArtifact("hsqldb", "hsqldb", "1.8.0.5"), new ProductArtifact("javax.transaction", "jta", "1.0.1B"), new ProductArtifact("ots-jts", "ots-jts", "1.0"), new ProductArtifact("jotm", "jotm", "1.4.3"), new ProductArtifact("jotm", "jotm-jrmp_stubs", "1.4.3"), new ProductArtifact("jotm", "jotm-iiop_stubs", "1.4.3"), new ProductArtifact("jotm", "jonas_timer", "1.4.3"), new ProductArtifact("jotm", "objectweb-datasource", "1.4.3"), new ProductArtifact("carol", "carol", "1.5.2"), new ProductArtifact("carol", "carol-properties", "1.0"), new ProductArtifact("xapool", "xapool", "1.3.1"), new ProductArtifact("commons-logging", "commons-logging", "1.1.1"));
    }

    @Override
    protected void cleanupProductHomeForZip(@Nonnull Product product, @Nonnull File snapshotDir) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, snapshotDir);
        org.apache.commons.io.FileUtils.deleteQuietly((File)new File(snapshotDir, "log/atlassian-jira.log"));
    }

    private void updateDbConfigXmlFromDataSource(Product product, File homeDir) throws MojoExecutionException {
        if (product.getDataSources().size() == 1) {
            DataSource ds = product.getDataSources().get(0);
            DatabaseType dbType = new DatabaseTypeFactory(this.log).getDatabaseType(ds).orElseThrow(() -> new MojoExecutionException("Could not find database type for " + ds));
            JiraProductHandler.updateDbConfigXml(homeDir, dbType, ds.getSchema());
        } else if (product.getDataSources().size() > 1) {
            throw new MojoExecutionException("Jira does not support multiple data sources");
        }
    }

    private static void setUpSharedHome(Product product, String parent) throws MojoExecutionException {
        File sharedHome;
        if (StringUtils.isBlank((CharSequence)product.getSharedHome())) {
            sharedHome = new File(parent, "shared-home");
            product.setSharedHome(sharedHome.getAbsolutePath());
        } else {
            sharedHome = new File(product.getSharedHome());
            if (sharedHome.isFile()) {
                String error = String.format("The specified shared home '%s' is a file, not a directory", product.getSharedHome());
                throw new MojoExecutionException(error);
            }
        }
        try {
            Files.createDirectories(sharedHome.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create shared home " + sharedHome, (Exception)e);
        }
    }

    private static void createClusterPropertiesFile(Product product, int nodeIndex, File homeDir) throws MojoExecutionException {
        File clusterPropertiesFile = new File(homeDir, "cluster.properties");
        if (!clusterPropertiesFile.isFile()) {
            Properties clusterProperties = new Properties();
            clusterProperties.setProperty("jira.node.id", "node" + nodeIndex);
            clusterProperties.setProperty("jira.shared.home", Objects.requireNonNull(product.getSharedHome()));
            clusterProperties.setProperty("ehcache.listener.port", String.valueOf(ProductHandlerUtil.pickFreePort(0)));
            clusterProperties.setProperty("ehcache.object.port", String.valueOf(ProductHandlerUtil.pickFreePort(0)));
            PropertyUtils.storeProperties(clusterProperties, clusterPropertiesFile, "Created by AMPS " + VersionUtils.getVersion());
        }
    }

    @VisibleForTesting
    static void createDbConfigXmlIfNone(File homeDir) throws MojoExecutionException {
        File dbConfigXml = new File(homeDir, FILENAME_DBCONFIG);
        if (dbConfigXml.exists()) {
            return;
        }
        try (InputStream templateIn = JiraProductHandler.class.getResourceAsStream("jira-dbconfig-template.xml");){
            if (templateIn == null) {
                throw new MojoExecutionException("Missing internal resource: jira-dbconfig-template.xml");
            }
            String template = IOUtils.toString((InputStream)templateIn, (Charset)StandardCharsets.UTF_8);
            File dbFile = JiraProductHandler.getHsqlDatabaseFile(homeDir);
            String jdbcUrl = "jdbc:hsqldb:file:" + dbFile.toURI().getPath();
            String result = template.replace("@jdbc-url@", jdbcUrl);
            org.apache.commons.io.FileUtils.writeStringToFile((File)dbConfigXml, (String)result, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to create config file: dbconfig.xml", (Exception)ioe);
        }
    }

    private static File getHsqlDatabaseFile(File homeDirectory) {
        return new File(homeDirectory, "database");
    }

    private static File getPluginHomeDirectory(Product product, File homeDir) {
        return Optional.ofNullable(product.getSharedHome()).filter(StringUtils::isNotBlank).map(File::new).orElse(homeDir);
    }

    private static Collection<XmlOverride> serverXmlJiraOverride() {
        return Collections.unmodifiableList(Arrays.asList(new XmlOverride("conf/server.xml", "//Connector", "relaxedPathChars", "[]|"), new XmlOverride("conf/server.xml", "//Connector", "relaxedQueryChars", "[]|{}^\\`\"<>")));
    }

    private String getFirstJiraHome(Product product) {
        return FileUtils.fixWindowsSlashes(this.getHomeDirectories(product).get(0).getAbsolutePath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<DataSource> getDataSourceFromJiraDSFile(Product jira) {
        String jiraHome = this.getFirstJiraHome(jira);
        File dsPropsFile = new File(jiraHome, JIRADS_PROPERTIES_FILE);
        if (!dsPropsFile.isFile()) return Optional.empty();
        DataSource dataSource = new DataSource();
        try (FileInputStream inputStream = new FileInputStream(dsPropsFile);){
            Properties dsProps = new Properties();
            dsProps.load(inputStream);
            dataSource.setJndi(dsProps.getProperty("jndi"));
            dataSource.setUrl(dsProps.getProperty("url").replace(JIRA_HOME_PLACEHOLDER, jiraHome));
            dataSource.setDriver(dsProps.getProperty("driver-class"));
            dataSource.setUsername(dsProps.getProperty("username"));
            dataSource.setPassword(dsProps.getProperty("password"));
            Optional<DataSource> optional = Optional.of(dataSource);
            return optional;
        }
        catch (IOException e) {
            this.log.warn((CharSequence)("failed to read " + dsPropsFile.getAbsolutePath()), (Throwable)e);
        }
        return Optional.empty();
    }

    private DataSource getHsqlDataSource(Product jira) {
        DataSource dataSource = new DataSource();
        dataSource.setJndi("jdbc/JiraDS");
        dataSource.setUrl(String.format("jdbc:hsqldb:%s/database", this.getFirstJiraHome(jira)));
        dataSource.setDriver("org.hsqldb.jdbcDriver");
        dataSource.setUsername("sa");
        dataSource.setPassword("");
        return dataSource;
    }

    @VisibleForTesting
    public static void updateDbConfigXml(File homeDir, DatabaseType dbType, String schema) throws MojoExecutionException {
        File dbConfigXml = new File(homeDir, FILENAME_DBCONFIG);
        if (!dbConfigXml.exists() || dbType == null) {
            return;
        }
        try {
            new XMLDocumentProcessor(new XMLDocumentHandler(dbConfigXml)).load().validate(new DbConfigValidator()).transform(new DatabaseTypeUpdaterTransformer(dbType)).transform(new SchemeUpdaterTransformer(dbType, schema)).saveIfModified();
        }
        catch (ValidationException e) {
            throw new MojoExecutionException("Validation of dbconfig.xml file failed", (Exception)e);
        }
    }

    private String getProjectDir(Product product) {
        Set projectDirs = this.getHomeDirectories(product).stream().map(File::getParent).collect(Collectors.toSet());
        if (projectDirs.size() == 1) {
            return (String)projectDirs.iterator().next();
        }
        throw new IllegalStateException("Expected a single project directory, but found " + projectDirs);
    }

    private static class JiraPluginProvider
    extends AbstractPluginProvider {
        private JiraPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-jira-plugin", salVersion));
        }

        @Override
        protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
            ArrayList<ProductArtifact> plugins = new ArrayList<ProductArtifact>(super.getPdkInstallArtifacts(pdkInstallVersion));
            plugins.add(new ProductArtifact("commons-fileupload", "commons-fileupload", "1.2.1"));
            return plugins;
        }
    }
}

