/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    @Nonnull
    public static File file(String parent, String ... kids) {
        return FileUtils.file(new File(parent), kids);
    }

    @Nonnull
    public static File file(@Nonnull File parent, String ... kids) {
        File cur = parent;
        for (String kid : kids) {
            cur = new File(cur, kid);
        }
        return cur;
    }

    public static boolean doesFileNameMatchArtifact(String fileName, String artifactId) {
        String pattern = "^" + artifactId + "-\\d.*$";
        return fileName.matches(pattern);
    }

    public static boolean doesFileNameVersionMatchArtifact(String fileName, String artifactId, String version) {
        String pattern = "^" + artifactId + "-\\d.*$";
        boolean deleteArtifact = true;
        if (fileName.matches(pattern)) {
            try {
                if (new ComparableVersion(FileUtils.fetchVersionFromJar(fileName)).compareTo(new ComparableVersion(version)) >= 0) {
                    deleteArtifact = false;
                }
            }
            catch (IOException e) {
                deleteArtifact = false;
                LOGGER.debug("Issue while fetching the version from '" + fileName + "'", (Throwable)e);
            }
        } else {
            deleteArtifact = false;
        }
        return deleteArtifact;
    }

    public static void deleteDir(File dir) {
        if (dir.exists()) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)dir);
        }
    }

    public static String fixWindowsSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public static void cleanDirectory(File directory, FileFilter filter) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles(filter);
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (File file : files) {
            try {
                org.apache.commons.io.FileUtils.forceDelete((File)file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void copyDirectory(File source, File destination, boolean preserveFileAttrs) throws IOException {
        if (!destination.mkdirs() && !destination.isDirectory()) {
            throw new IOException("Destination '" + destination + "' directory cannot be created");
        }
        File[] srcFiles = source.listFiles();
        for (File srcFile : srcFiles = srcFiles != null ? srcFiles : new File[]{}) {
            File dstFile = new File(destination, srcFile.getName());
            if (srcFile.isDirectory()) {
                FileUtils.copyDirectory(srcFile, dstFile, preserveFileAttrs);
                continue;
            }
            org.apache.commons.io.FileUtils.copyFile((File)srcFile, (File)dstFile, (boolean)preserveFileAttrs);
            if (!preserveFileAttrs || !srcFile.canExecute()) continue;
            FileUtils.makeExecutable(dstFile);
        }
    }

    public static void makeExecutable(File file) {
        if (file != null && file.isFile() && !file.canExecute() && !file.setExecutable(true)) {
            LOGGER.warn("Couldn't make {} executable", (Object)file);
        }
    }

    @ParametersAreNonnullByDefault
    public static String readFileToString(String name, Class<?> loadingClass, Charset encoding) {
        InputStream fileStream = loadingClass.getResourceAsStream(name);
        Objects.requireNonNull(fileStream, String.format("Could not find '%s' on classpath of %s", name, loadingClass.getName()));
        try {
            return IOUtils.toString((InputStream)fileStream, (Charset)encoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static Optional<String> readFileToString(@Nonnull File file, @Nonnull Charset encoding) {
        try {
            return Optional.ofNullable(org.apache.commons.io.FileUtils.readFileToString((File)file, (Charset)encoding));
        }
        catch (Exception e) {
            LOGGER.debug("Failed to read file '" + file + "'", (Throwable)e);
            return Optional.empty();
        }
    }

    public static void setLastModified(File file, long time) {
        if (file != null && file.exists() && !file.setLastModified(time)) {
            LOGGER.warn("Could not set last modified time of {} to {}", (Object)file, (Object)time);
        }
    }

    public static void makeDirectory(File file) {
        boolean made = file.mkdir();
        LOGGER.debug("{} made = {}", (Object)file, (Object)made);
    }

    public static void makeDirectories(File file) {
        boolean made = file.mkdirs();
        LOGGER.debug("{} made = {}", (Object)file, (Object)made);
    }

    public static String fetchVersionFromJar(String fileName) throws IOException {
        String versionNumber;
        block13: {
            versionNumber = "";
            try (JarFile jar = new JarFile(fileName);){
                Manifest manifest = jar.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                if (attributes == null) break block13;
                for (Object obj : attributes.keySet()) {
                    Attributes.Name key = (Attributes.Name)obj;
                    String keyword = key.toString();
                    if (!"Implementation-Version".equals(keyword) && !"Bundle-Version".equals(keyword)) continue;
                    versionNumber = (String)attributes.get(key);
                    break;
                }
            }
        }
        return versionNumber;
    }
}

