/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.manager;

import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class BaseUrlUtils {
    public static String getBaseUrl(String server, int actualWebPort, @Nullable String contextPath) {
        return BaseUrlUtils.formatServer(server) + BaseUrlUtils.formatPort(actualWebPort) + BaseUrlUtils.formatContextPath(contextPath);
    }

    private static String formatServer(String server) {
        if (StringUtils.isBlank((CharSequence)server)) {
            throw new IllegalArgumentException(String.format("Invalid server name '%s'", server));
        }
        return StringUtils.prependIfMissing((String)server, (CharSequence)"http://", (CharSequence[])new CharSequence[0]);
    }

    private static String formatPort(int port) {
        return port != 80 ? ":" + port : "";
    }

    private static String formatContextPath(String contextPath) {
        if (StringUtils.isBlank((CharSequence)contextPath)) {
            return "";
        }
        return StringUtils.prependIfMissing((String)contextPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    private BaseUrlUtils() {
    }
}

