/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractProductHandler;
import com.atlassian.maven.plugins.amps.product.JavaModulePackage;
import com.atlassian.maven.plugins.amps.product.manager.WebAppManager;
import com.atlassian.maven.plugins.amps.util.JvmArgsFix;
import com.atlassian.maven.plugins.amps.util.MavenProjectLoader;
import com.atlassian.maven.plugins.amps.util.ProductHandlerUtil;
import com.atlassian.maven.plugins.amps.util.PropertyUtils;
import com.atlassian.maven.plugins.amps.util.ant.AntJavaExecutorThread;
import com.atlassian.maven.plugins.amps.util.ant.JavaTaskFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.apache.tools.ant.taskdefs.Java;

public class BitbucketProductHandler
extends AbstractProductHandler {
    @VisibleForTesting
    static final String EMBEDDED_ELASTICSEARCH_HTTP_PORT = "plugin.embedded-elasticsearch.http.port";
    @VisibleForTesting
    static final String EMBEDDED_ELASTICSEARCH_TCP_PORT = "plugin.embedded-elasticsearch.transport.tcp.port";
    @VisibleForTesting
    static final String SSH_PORT = "plugin.ssh.port";
    @VisibleForTesting
    static final String HAZELCAST_GROUP = "hazelcast.group.name";
    @VisibleForTesting
    static final String HAZELCAST_PORT = "hazelcast.port";
    private static final String ADMIN_OBJECT_NAME = "org.springframework.boot:type=Admin,name=SpringApplication";
    private static final int DEFAULT_JMX_PORT = 7995;
    private static final DefaultArtifactVersion FIRST_SEARCH_VERSION = new DefaultArtifactVersion("4.6.0-a0");
    private static final DefaultArtifactVersion FIRST_SPRING_BOOT_VERSION = new DefaultArtifactVersion("5.0.0-a0");
    private static final String JMX_PORT_FILE = "jmx-port";
    private static final String JMX_URL_FORMAT = "service:jmx:rmi:///jndi/rmi://127.0.0.1:%1$d/jmxrmi";
    private static final String SEARCH_GROUP_ID = "com.atlassian.bitbucket.search";
    private static final String SERVER_GROUP_ID = "com.atlassian.bitbucket.server";
    private static final String ELASTICSEARCH_BASEURL = "plugin.search.elasticsearch.baseurl";
    private static final String HAZELCAST_NETWORK_TCPIP = "hazelcast.network.tcpip";
    private static final String HAZELCAST_NETWORK_TCPIP_MEMBERS = "hazelcast.network.tcpip.members";
    private static final String HAZELCAST_PASSWORD = "hazelcast.group.password";
    private final MavenProjectLoader projectLoader;
    private final ProjectBuilder projectBuilder;
    private final JavaTaskFactory taskFactory;
    private final WebAppManager webAppManager;

    public BitbucketProductHandler(MavenContext context, MavenGoals goals, RepositorySystem repositorySystem, MavenProjectLoader projectLoader, ProjectBuilder projectBuilder, ArtifactResolver artifactResolver, WebAppManager webAppManager) {
        super(context, goals, new BitbucketPluginProvider(), repositorySystem, artifactResolver);
        this.projectLoader = Objects.requireNonNull(projectLoader);
        this.projectBuilder = Objects.requireNonNull(projectBuilder);
        this.webAppManager = Objects.requireNonNull(webAppManager);
        this.taskFactory = new JavaTaskFactory(this.log);
    }

    @Override
    protected void cleanupProductHomeForZip(@Nonnull Product product, @Nonnull File snapshotDir) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, snapshotDir);
        FileUtils.deleteQuietly((File)new File(snapshotDir, "log/atlassian-bitbucket.log"));
        FileUtils.deleteQuietly((File)new File(snapshotDir, ".osgi-cache"));
    }

    @Override
    @Nonnull
    public String getId() {
        return "bitbucket";
    }

    @Override
    @Nonnull
    public List<ProductArtifact> getAdditionalPlugins(Product bitbucket) throws MojoExecutionException {
        ArrayList<ProductArtifact> additionalPlugins = new ArrayList<ProductArtifact>();
        if (this.usesElasticSearch(bitbucket)) {
            this.getSearchPluginDependency(bitbucket).ifPresent(dependency -> additionalPlugins.add(new ProductArtifact(SEARCH_GROUP_ID, "embedded-elasticsearch-plugin", dependency.getVersion())));
        }
        return additionalPlugins;
    }

    private boolean usesElasticSearch(Product bitbucket) {
        return new DefaultArtifactVersion(bitbucket.getVersion()).compareTo((ArtifactVersion)FIRST_SEARCH_VERSION) >= 0;
    }

    private Optional<Dependency> getSearchPluginDependency(Product bitbucket) throws MojoExecutionException {
        Artifact bitbucketParentPom = this.repositorySystem.createProjectArtifact(SERVER_GROUP_ID, "bitbucket-parent", bitbucket.getVersion());
        return this.projectLoader.loadMavenProject(this.context.getProject(), bitbucketParentPom, this.projectBuilder).flatMap(mavenProject -> Optional.ofNullable(mavenProject.getDependencyManagement()).flatMap(dependencyManagement -> dependencyManagement.getDependencies().stream().filter(dep -> SEARCH_GROUP_ID.equals(dep.getGroupId())).findFirst()));
    }

    @Override
    @Nonnull
    public ProductArtifact getArtifact() {
        return new ProductArtifact(SERVER_GROUP_ID, "bitbucket-webapp");
    }

    @Override
    @Nonnull
    public File getBundledPluginPath(Product product, File productDir) {
        File bundledPluginsDir = new File(productDir, "WEB-INF/atlassian-bundled-plugins");
        if (bundledPluginsDir.isDirectory()) {
            return bundledPluginsDir;
        }
        return new File(productDir, "WEB-INF/classes/bitbucket-bundled-plugins.zip");
    }

    @Override
    @Nonnull
    public String getDefaultContainerId() {
        return "tomcat8x";
    }

    @Override
    public int getDefaultHttpPort() {
        return 7990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8447;
    }

    @Override
    @Nonnull
    public Map<String, String> getSystemProperties(Product product, int nodeIndex) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"johnson.spring.lifecycle.synchronousStartup", (Object)Boolean.TRUE.toString());
        this.defaultSyspropsFromFile(product);
        File homeDirectory = this.getHomeDirectories(product).get(nodeIndex);
        String baseUrl = product.getBaseUrlForNode(nodeIndex);
        builder.put((Object)"baseurl", (Object)baseUrl);
        builder.put((Object)"baseurl.display", (Object)baseUrl);
        builder.put((Object)"bitbucket.home", (Object)BitbucketProductHandler.fixSlashes(homeDirectory.getPath()));
        if (product.isMultiNode()) {
            BitbucketProductHandler.configureNodeForElasticsearch(product, nodeIndex);
            BitbucketProductHandler.setUpSsh(product, nodeIndex);
            BitbucketProductHandler.setUpHazelcast(product, nodeIndex);
            builder.put((Object)"cluster.node.name", (Object)(product.getInstanceId() + "-" + nodeIndex));
        }
        return builder.build();
    }

    private static void configureNodeForElasticsearch(Product product, int nodeIndex) {
        Node node = product.getNodes().get(nodeIndex);
        node.defaultSystemProperty(EMBEDDED_ELASTICSEARCH_HTTP_PORT, () -> String.valueOf(ProductHandlerUtil.pickFreePort(0)));
        node.defaultSystemProperty(EMBEDDED_ELASTICSEARCH_TCP_PORT, () -> String.valueOf(ProductHandlerUtil.pickFreePort(0)));
        String nodeZeroElasticsearchHttpPort = product.getNodes().get(0).getSystemProperties().get(EMBEDDED_ELASTICSEARCH_HTTP_PORT);
        String nodeZeroElasticsearchTcpPort = product.getNodes().get(0).getSystemProperties().get(EMBEDDED_ELASTICSEARCH_TCP_PORT);
        if (StringUtils.isBlank((CharSequence)nodeZeroElasticsearchHttpPort) || StringUtils.isBlank((CharSequence)nodeZeroElasticsearchTcpPort)) {
            throw new IllegalStateException(String.format("First node's Elasticsearch HTTP or TCP port is blank: '%s', '%s'", nodeZeroElasticsearchHttpPort, nodeZeroElasticsearchTcpPort));
        }
        product.defaultSystemProperty(ELASTICSEARCH_BASEURL, () -> String.format("http://localhost:%s", nodeZeroElasticsearchHttpPort));
    }

    private static void setUpSsh(Product product, int nodeIndex) {
        Node node = product.getNodes().get(nodeIndex);
        node.defaultSystemProperty(SSH_PORT, () -> String.valueOf(ProductHandlerUtil.pickFreePort(0)));
    }

    private static void setUpHazelcast(Product product, int nodeIndex) {
        if (nodeIndex == 0) {
            product.getNodes().forEach(nodeToDefault -> nodeToDefault.defaultSystemProperty(HAZELCAST_PORT, () -> String.valueOf(ProductHandlerUtil.pickFreePort(0))));
            product.defaultSystemProperty(HAZELCAST_NETWORK_TCPIP, () -> String.valueOf(true));
            product.defaultSystemProperty(HAZELCAST_PASSWORD, () -> "admin");
            product.defaultSystemProperty(HAZELCAST_NETWORK_TCPIP_MEMBERS, () -> BitbucketProductHandler.getHazelcastNetworkTcpMembers(product));
            product.defaultSystemProperty(HAZELCAST_GROUP, () -> String.valueOf(UUID.randomUUID()));
        }
    }

    private static String getHazelcastNetworkTcpMembers(Product product) {
        return product.getNodes().stream().map(Node::getSystemProperties).map(p -> "127.0.0.1:" + (String)p.get(HAZELCAST_PORT)).collect(Collectors.joining(","));
    }

    @Override
    @Nonnull
    public Optional<ProductArtifact> getTestResourcesArtifact() {
        return Optional.of(new ProductArtifact(SERVER_GROUP_ID, "bitbucket-it-resources"));
    }

    @Override
    @Nonnull
    public Optional<File> getUserInstalledPluginsDirectory(Product product, File webappDir, File homeDir) {
        File baseDir = homeDir;
        File sharedHomeDir = new File(homeDir, "shared");
        if (sharedHomeDir.exists()) {
            baseDir = sharedHomeDir;
        }
        return Optional.of(new File(new File(baseDir, "plugins"), "installed-plugins"));
    }

    @Override
    protected void customiseInstance(Product product, File homeDir, File explodedWarDir) {
        if (product.isMultiNode()) {
            this.configureCluster(homeDir, product);
        }
    }

    private void configureCluster(File homeDir, Product product) {
        product.defaultSystemProperty("bitbucket.shared.home", () -> this.getSharedHome(product).getPath());
    }

    private void defaultSyspropsFromFile(Product product) {
        this.getBitbucketProperties(product).ifPresent(props -> {
            for (Map.Entry<Object, Object> property : props.entrySet()) {
                product.defaultSystemProperty(String.valueOf(property.getKey()), () -> String.valueOf(property.getValue()));
            }
        });
    }

    private Optional<Properties> getBitbucketProperties(Product product) {
        File propertiesFile = new File(this.getSharedHome(product), "bitbucket.properties");
        try {
            return Optional.of(PropertyUtils.load(propertiesFile));
        }
        catch (MojoExecutionException e) {
            return Optional.empty();
        }
    }

    private File getSharedHome(Product product) {
        if (StringUtils.isNotBlank((CharSequence)product.getSharedHome())) {
            return new File(product.getSharedHome());
        }
        return new File(this.getHomeDirectories(product).get(0), "shared");
    }

    @Override
    public void stop(@Nonnull Product product) throws MojoExecutionException {
        if (BitbucketProductHandler.isSpringBoot(product)) {
            int jmxPort = this.readJmxPort(product);
            boolean connected = false;
            try (JMXConnector connector = this.createConnector(jmxPort);){
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connected = true;
                connection.invoke(new ObjectName(ADMIN_OBJECT_NAME), "shutdown", null, null);
            }
            catch (InstanceNotFoundException e) {
                throw new MojoExecutionException("Spring Boot administration is not available; Bitbucket Server will need to be stopped manually", (Exception)e);
            }
            catch (Exception e) {
                if (connected) {
                    this.log.debug((CharSequence)"Bitbucket Server has stopped");
                }
                this.log.warn((CharSequence)"There was an error attempting to stop Bitbucket Server", (Throwable)e);
            }
        } else {
            this.webAppManager.stopWebapp(product, this.context);
        }
    }

    @Override
    @Nonnull
    protected File extractApplication(Product product) throws MojoExecutionException {
        ProductArtifact artifact = this.getArtifact(product);
        if ("RELEASE".equals(artifact.getVersion()) || "LATEST".equals(artifact.getVersion())) {
            this.setLatestStableVersion(product, artifact);
        }
        File baseDir = this.getBaseDirectory(product);
        if (BitbucketProductHandler.isSpringBoot(product)) {
            File appDir = new File(baseDir, "app");
            this.goals.unpackWebappWar(appDir, artifact);
            return appDir;
        }
        return this.goals.copyWebappWar(artifact, baseDir, product.getId());
    }

    @Override
    protected void fixJvmArgs(Product product) {
        String jvmArgs = JvmArgsFix.empty().with("-Xmx", "1g").withAddOpens(ADD_OPENS_FOR_TOMCAT).withAddOpens(ADD_OPENS_FOR_FELIX).withAddOpens(new JavaModulePackage("java.base", "sun.nio.ch")).apply(product.getJvmArgs());
        product.setJvmArgs(jvmArgs);
    }

    @Override
    @Nonnull
    protected List<Node> startProduct(Product product, File productFile, List<Map<String, String>> systemProperties) throws MojoExecutionException {
        if (BitbucketProductHandler.isSpringBoot(product)) {
            this.startNodes(product, productFile, systemProperties);
            return product.getNodes();
        }
        return this.webAppManager.startWebapp(productFile, systemProperties, Collections.emptyList(), Collections.emptyList(), product, this.context);
    }

    @Override
    protected boolean supportsStaticPlugins() {
        return true;
    }

    @Nonnull
    private void startNodes(Product product, File app, List<Map<String, String>> systemProperties) throws MojoExecutionException {
        List<Node> nodes = product.getNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.size(); ++nodeIndex) {
            Node node = nodes.get(nodeIndex);
            int connectorPort = node.getWebPort();
            int jmxPort = this.pickJmxPort(product, connectorPort);
            Map<String, String> finalSystemProperties = BitbucketProductHandler.addJmxProperties(systemProperties.get(nodeIndex), jmxPort);
            this.startNode(product, node, app, finalSystemProperties, jmxPort);
        }
    }

    @Nonnull
    private void startNode(Product product, Node node, File app, Map<String, String> systemProperties, int jmxPort) throws MojoExecutionException {
        AntJavaExecutorThread thread = this.startJavaThread(product, node, app, systemProperties);
        this.waitUntilReady(thread, jmxPort, product.getStartupTimeout());
    }

    private static Map<String, String> addJmxProperties(Map<String, String> properties, int jmxPort) {
        HashMap<String, String> updatedProperties = new HashMap<String, String>(properties);
        updatedProperties.put("com.sun.management.jmxremote.authenticate", "false");
        updatedProperties.put("com.sun.management.jmxremote.port", String.valueOf(jmxPort));
        updatedProperties.put("com.sun.management.jmxremote.ssl", "false");
        updatedProperties.put("com.sun.management.jmxremote.host", "127.0.0.1");
        updatedProperties.put("java.rmi.server.hostname", "127.0.0.1");
        return updatedProperties;
    }

    private static String fixSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    private static InetAddress getLoopbackAddress() {
        try {
            return InetAddress.getByAddress("localhost", new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            return InetAddress.getLoopbackAddress();
        }
    }

    private static boolean isSpringBoot(Product product) {
        return new DefaultArtifactVersion(product.getVersion()).compareTo((ArtifactVersion)FIRST_SPRING_BOOT_VERSION) >= 0;
    }

    private static Optional<String> normalizeClientAuth(String value) {
        switch (StringUtils.defaultString((String)value)) {
            case "need": 
            case "require": 
            case "required": 
            case "true": 
            case "yes": {
                return Optional.of("need");
            }
            case "optional": 
            case "want": {
                return Optional.of("want");
            }
        }
        return Optional.empty();
    }

    private JMXConnector createConnector(int jmxPort) throws IOException {
        JMXServiceURL serviceURL = new JMXServiceURL(String.format(JMX_URL_FORMAT, jmxPort));
        return JMXConnectorFactory.connect(serviceURL);
    }

    private int pickJmxPort(Product product, int connectorPort) throws MojoExecutionException {
        int jmxPort = ProductHandlerUtil.pickFreePort(7995 == connectorPort ? 0 : 7995, BitbucketProductHandler.getLoopbackAddress());
        if (jmxPort != 7995) {
            Path jmxFile = this.getBaseDirectory(product).toPath().resolve(JMX_PORT_FILE);
            try {
                Files.write(jmxFile, String.valueOf(jmxPort).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("JMX port 7995 is not available, and the automatically-selected replacement could not be written to " + jmxFile.toAbsolutePath(), (Exception)e);
            }
        }
        return jmxPort;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readJmxPort(Product product) throws MojoExecutionException {
        Path jmxFile = this.getBaseDirectory(product).toPath().resolve(JMX_PORT_FILE);
        try (BufferedReader reader = Files.newBufferedReader(jmxFile, StandardCharsets.UTF_8);){
            int n = Integer.parseInt(reader.readLine());
            return n;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return 7995;
        }
        catch (IOException e) {
            throw new MojoExecutionException("The JMX port could not be read from " + jmxFile.toAbsolutePath(), (Exception)e);
        }
        catch (NumberFormatException e) {
            throw new MojoExecutionException("The JMX port in " + jmxFile.toAbsolutePath() + " is not valid", (Exception)e);
        }
    }

    private AntJavaExecutorThread startJavaThread(Product product, Node node, File app, Map<String, String> properties) {
        Java java = this.taskFactory.newJavaTask(JavaTaskFactory.output(product.getOutput()).systemProperties(properties));
        java.createClasspath().createPathElement().setLocation(app);
        java.createJvmarg().setLine(product.getJvmArgs());
        java.createJvmarg().setLine(node.getDebugArgs());
        java.createArg().setValue("--server.port=" + node.getWebPort());
        if (product.isHttps()) {
            java.createArg().setValue("--server.ssl.enabled=true");
            java.createArg().setValue("--server.ssl.key-alias=" + product.getHttpsKeyAlias());
            java.createArg().setValue("--server.ssl.key-password=" + product.getHttpsKeystorePass());
            java.createArg().setValue("--server.ssl.key-store=" + product.getHttpsKeystoreFile());
            java.createArg().setValue("--server.ssl.key-store-password=" + product.getHttpsKeystorePass());
            java.createArg().setValue("--server.ssl.protocol=" + product.getHttpsSSLProtocol());
            BitbucketProductHandler.normalizeClientAuth(product.getHttpsClientAuth()).ifPresent(clientAuth -> java.createArg().setValue("--server.ssl.client-auth=" + clientAuth));
        }
        java.createArg().setValue("--server.contextPath=" + product.getContextPath());
        java.createArg().setValue("--spring.application.admin.enabled=true");
        java.createArg().setValue("--spring.application.admin.jmx-name=org.springframework.boot:type=Admin,name=SpringApplication");
        java.setClassname("org.springframework.boot.loader.WarLauncher");
        AntJavaExecutorThread javaThread = new AntJavaExecutorThread(java);
        javaThread.start();
        return javaThread;
    }

    private void waitUntilReady(AntJavaExecutorThread javaThread, int jmxPort, int wait) throws MojoExecutionException {
        long timeout = System.currentTimeMillis() + (long)wait;
        while (System.currentTimeMillis() < timeout) {
            if (javaThread.isFinished()) {
                throw new MojoExecutionException("Bitbucket Server failed to start", (Exception)((Object)javaThread.getBuildException()));
            }
            try (JMXConnector connector = this.createConnector(jmxPort);){
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                Boolean ready = (Boolean)connection.getAttribute(new ObjectName(ADMIN_OBJECT_NAME), "Ready");
                if (Boolean.TRUE.equals(ready)) {
                    return;
                }
            }
            catch (AttributeNotFoundException e) {
                throw new MojoExecutionException("org.springframework.boot:type=Admin,name=SpringApplication has no \"Ready\" attribute", (Exception)e);
            }
            catch (InstanceNotFoundException e) {
                this.log.debug((CharSequence)"Spring Boot administration for Bitbucket Server is not available yet");
            }
            catch (ReflectionException e) {
                throw new MojoExecutionException("Failed to retrieve \"Ready\" attribute", (Exception)e);
            }
            catch (IOException e) {
                boolean rethrow = true;
                Throwable t = e;
                while (t != null) {
                    if (t instanceof ConnectException) {
                        this.log.debug((CharSequence)"Bitbucket Server's MBeanServer is not available yet");
                        rethrow = false;
                        t = null;
                        continue;
                    }
                    t = t.getCause();
                }
                if (rethrow) {
                    throw new MojoExecutionException("Could not be connect to Bitbucket Server via JMX", (Exception)e);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            try {
                this.log.debug((CharSequence)"Waiting to retry");
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while waiting for Bitbucket Server to start");
            }
        }
        javaThread.interrupt();
        throw new MojoExecutionException("Timed out waiting for Bitbucket Server to start");
    }

    private static class BitbucketPluginProvider
    extends AbstractPluginProvider {
        private BitbucketPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Collections.emptyList();
        }
    }
}

