/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import java.util.Optional;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class MavenProjectLoader {
    public Optional<MavenProject> loadMavenProject(MavenSession session, MavenProject project, Artifact pomArtifact) throws MojoExecutionException {
        try {
            ProjectBuilder projectBuilder = (ProjectBuilder)session.getContainer().lookup(ProjectBuilder.class);
            ProjectBuildingRequest request = new DefaultProjectBuildingRequest(project.getProjectBuildingRequest()).setRemoteRepositories(project.getRemoteArtifactRepositories());
            return Optional.ofNullable(projectBuilder.build(pomArtifact, request).getProject());
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Could not get the ProjectBuilder from the maven session", (Exception)((Object)e));
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(String.format("Could not build the MavenProject for %s", pomArtifact), (Exception)((Object)e));
        }
    }
}

