/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.LibArtifact;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabase;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractJiraDatabase
extends AbstractMojo
implements JiraDatabase {
    private DataSource dataSource;
    protected LibArtifact lib;

    public AbstractJiraDatabase(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
    }

    protected abstract String dropDatabase() throws MojoExecutionException;

    protected abstract String createDatabase() throws MojoExecutionException;

    protected abstract String dropUser();

    protected abstract String createUser();

    protected abstract String grantPermissionForUser() throws MojoExecutionException;

    protected Xpp3Dom systemDatabaseConfiguration() {
        return MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("driver"), this.dataSource.getDriver()), MojoExecutor.element(MojoExecutor.name("url"), this.dataSource.getDefaultDatabase()), MojoExecutor.element(MojoExecutor.name("username"), this.dataSource.getSystemUsername()), MojoExecutor.element(MojoExecutor.name("password"), this.dataSource.getSystemPassword()), MojoExecutor.element(MojoExecutor.name("autocommit"), "true"));
    }

    protected Xpp3Dom productDatabaseConfiguration() {
        return MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("driver"), this.dataSource.getDriver()), MojoExecutor.element(MojoExecutor.name("url"), this.dataSource.getUrl()), MojoExecutor.element(MojoExecutor.name("username"), this.dataSource.getUsername()), MojoExecutor.element(MojoExecutor.name("password"), this.dataSource.getPassword()), MojoExecutor.element(MojoExecutor.name("autocommit"), "true"));
    }

    protected abstract String getDatabaseName(String var1) throws MojoExecutionException;

    @Override
    public List<Dependency> getDependencies() {
        if (this.dataSource.getLibArtifacts() == null || this.dataSource.getLibArtifacts().isEmpty()) {
            return null;
        }
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (LibArtifact libArtifact : this.dataSource.getLibArtifacts()) {
            Dependency dependency = new Dependency();
            dependency.setGroupId(libArtifact.getGroupId());
            dependency.setArtifactId(libArtifact.getArtifactId());
            dependency.setVersion(libArtifact.getVersion());
            dependencies.add(dependency);
        }
        return dependencies;
    }

    @Override
    public Xpp3Dom getConfigImportFile() {
        Xpp3Dom pluginConfiguration = this.productDatabaseConfiguration();
        pluginConfiguration.addChild(MojoExecutor.element(MojoExecutor.name("srcFiles"), MojoExecutor.element(MojoExecutor.name("srcFile"), this.getDataSource().getDumpFilePath())).toDom());
        return pluginConfiguration;
    }

    @Override
    public Xpp3Dom getConfigDatabaseTool() throws MojoExecutionException {
        return null;
    }
}

