/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.XmlOverride;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseType;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.atlassian.maven.plugins.amps.util.JvmArgsFix;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class JiraProductHandler
extends AbstractWebappProductHandler {
    @VisibleForTesting
    static final String INSTALLED_PLUGINS_DIR = "installed-plugins";
    @VisibleForTesting
    static final String PLUGINS_DIR = "plugins";
    @VisibleForTesting
    static final String BUNDLED_PLUGINS_UNZIPPED = "WEB-INF/atlassian-bundled-plugins";
    @VisibleForTesting
    static final String BUNDLED_PLUGINS_FROM_4_1 = "WEB-INF/classes/atlassian-bundled-plugins.zip";
    @VisibleForTesting
    static final String BUNDLED_PLUGINS_UPTO_4_0 = "WEB-INF/classes/com/atlassian/jira/plugin/atlassian-bundled-plugins.zip";
    @VisibleForTesting
    static final String FILENAME_DBCONFIG = "dbconfig.xml";
    private static final String JIRADS_PROPERTIES_FILE = "JiraDS.properties";
    private static final String JIRA_HOME_PLACEHOLDER = "${jirahome}";

    private static void checkNotFile(File sharedHomeDir) {
        if (sharedHomeDir.isFile()) {
            String error = String.format("The specified shared home '%s' is a file, not a directory", sharedHomeDir);
            throw new IllegalArgumentException(error);
        }
    }

    private static void createIfNotExists(File sharedHome) {
        sharedHome.mkdirs();
        if (!sharedHome.isDirectory()) {
            String error = String.format("The specified shared home '%s' cannot be created", sharedHome);
            throw new IllegalStateException(error);
        }
    }

    public JiraProductHandler(MavenContext context, MavenGoals goals, ArtifactFactory artifactFactory) {
        super(context, goals, new JiraPluginProvider(), artifactFactory);
    }

    @Override
    public String getId() {
        return "jira";
    }

    @Override
    protected void customiseInstance(Product ctx, File homeDir, File explodedWarDir) {
        if (new ComparableVersion(ctx.getVersion()).compareTo(new ComparableVersion("7.12.0")) >= 0) {
            ctx.setCargoXmlOverrides(this.serverXmlJiraOverride());
        }
    }

    @Override
    protected void fixJvmArgs(Product ctx) {
        ComparableVersion productVersion = new ComparableVersion(ctx.getVersion());
        if (productVersion.compareTo(new ComparableVersion("8.0.0-ALPHA")) >= 0) {
            ctx.setJvmArgs(JvmArgsFix.empty().with("-Xmx", "2g").with("-Xms", "1g").apply(ctx.getJvmArgs()));
        } else if (productVersion.compareTo(new ComparableVersion("7.7.0-ALPHA")) >= 0) {
            ctx.setJvmArgs(JvmArgsFix.empty().with("-Xmx", "768m").with("-Xms", "384m").apply(ctx.getJvmArgs()));
        } else {
            super.fixJvmArgs(ctx);
        }
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.jira", "atlassian-jira-webapp", "RELEASE");
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact("com.atlassian.jira.plugins", "jira-plugin-test-resources");
    }

    @Override
    public int getDefaultHttpPort() {
        return 2990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8442;
    }

    protected static File getHsqlDatabaseFile(File homeDirectory) {
        return new File(homeDirectory, "database");
    }

    @Override
    public String getDefaultContainerId() {
        return "tomcat7x";
    }

    @Override
    @Nonnull
    protected Collection<String> getExtraJarsToSkipWhenScanningForTldsAndWebFragments() {
        return ImmutableList.of((Object)"jotm*.jar", (Object)"xapool*.jar");
    }

    @Override
    public Map<String, String> getSystemProperties(Product ctx) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.putAll(super.getSystemProperties(ctx));
        properties.put((Object)"jira.home", (Object)FileUtils.fixWindowsSlashes(this.getHomeDirectory(ctx).getPath()));
        properties.put((Object)"cargo.servlet.uriencoding", (Object)"UTF-8");
        if (ctx.isAwaitFullInitialization()) {
            properties.put((Object)"com.atlassian.jira.startup.LauncherContextListener.SYNCHRONOUS", (Object)"true");
        }
        return properties.build();
    }

    @Override
    protected DataSource getDefaultDataSource(Product ctx) {
        DataSource dataSource = new DataSource();
        String jiraHome = FileUtils.fixWindowsSlashes(this.getHomeDirectory(ctx).getAbsolutePath());
        File dsPropsFile = new File(this.getHomeDirectory(ctx), JIRADS_PROPERTIES_FILE);
        if (dsPropsFile.exists()) {
            Properties dsProps = new Properties();
            try {
                dsProps.load(new FileInputStream(dsPropsFile));
                dataSource.setJndi(dsProps.getProperty("jndi"));
                dataSource.setUrl(dsProps.getProperty("url").replace(JIRA_HOME_PLACEHOLDER, jiraHome));
                dataSource.setDriver(dsProps.getProperty("driver-class"));
                dataSource.setUsername(dsProps.getProperty("username"));
                dataSource.setPassword(dsProps.getProperty("password"));
                return dataSource;
            }
            catch (IOException e) {
                this.log.warn((CharSequence)("failed to read " + dsPropsFile.getAbsolutePath()), (Throwable)e);
            }
        }
        dataSource.setJndi("jdbc/JiraDS");
        dataSource.setUrl(String.format("jdbc:hsqldb:%s/database", jiraHome));
        dataSource.setDriver("org.hsqldb.jdbcDriver");
        dataSource.setUsername("sa");
        dataSource.setPassword("");
        return dataSource;
    }

    @Override
    public File getUserInstalledPluginsDirectory(Product product, File webappDir, File homeDir) {
        File pluginHomeDirectory = this.getPluginHomeDirectory(product.getSharedHome(), homeDir);
        return new File(new File(pluginHomeDirectory, PLUGINS_DIR), INSTALLED_PLUGINS_DIR);
    }

    private File getPluginHomeDirectory(String sharedHomePath, File homeDir) {
        if (StringUtils.isBlank((CharSequence)sharedHomePath)) {
            return homeDir;
        }
        File sharedHomeDir = new File(sharedHomePath);
        JiraProductHandler.checkNotFile(sharedHomeDir);
        JiraProductHandler.createIfNotExists(sharedHomeDir);
        return sharedHomeDir;
    }

    @Override
    public List<ProductArtifact> getExtraContainerDependencies() {
        return Arrays.asList(new ProductArtifact("hsqldb", "hsqldb", "1.8.0.5"), new ProductArtifact("javax.transaction", "jta", "1.0.1B"), new ProductArtifact("ots-jts", "ots-jts", "1.0"), new ProductArtifact("jotm", "jotm", "1.4.3"), new ProductArtifact("jotm", "jotm-jrmp_stubs", "1.4.3"), new ProductArtifact("jotm", "jotm-iiop_stubs", "1.4.3"), new ProductArtifact("jotm", "jonas_timer", "1.4.3"), new ProductArtifact("jotm", "objectweb-datasource", "1.4.3"), new ProductArtifact("carol", "carol", "1.5.2"), new ProductArtifact("carol", "carol-properties", "1.0"), new ProductArtifact("xapool", "xapool", "1.3.1"), new ProductArtifact("commons-logging", "commons-logging", "1.1.1"));
    }

    @Override
    public File getBundledPluginPath(Product ctx, File appDir) {
        File bundleDir = new File(appDir, BUNDLED_PLUGINS_UNZIPPED);
        if (bundleDir.exists() && bundleDir.isDirectory()) {
            return bundleDir;
        }
        String bundledPluginPluginsPath = BUNDLED_PLUGINS_FROM_4_1;
        String[] version = ctx.getVersion().split("-", 2)[0].split("\\.");
        try {
            long minor;
            long major = Long.parseLong(version[0]);
            long l = minor = version.length > 1 ? Long.parseLong(version[1]) : 0L;
            if (major < 4L || major == 4L && minor == 0L) {
                bundledPluginPluginsPath = BUNDLED_PLUGINS_UPTO_4_0;
            }
        }
        catch (NumberFormatException e) {
            this.log.debug((CharSequence)String.format("Unable to parse JIRA version '%s', assuming JIRA 4.1 or newer.", ctx.getVersion()), (Throwable)e);
        }
        return new File(appDir, bundledPluginPluginsPath);
    }

    @Override
    public void processHomeDirectory(Product ctx, File homeDir) throws MojoExecutionException {
        super.processHomeDirectory(ctx, homeDir);
        JiraProductHandler.createDbConfigXmlIfNecessary(homeDir);
        if (ctx.getDataSources().size() == 1) {
            DataSource ds = ctx.getDataSources().get(0);
            JiraDatabaseType dbType = JiraDatabaseType.getDatabaseType(ds).orElseThrow(() -> new MojoExecutionException("Could not find database type for " + ds));
            this.updateDbConfigXml(homeDir, dbType, ds.getSchema());
        } else if (ctx.getDataSources().size() > 1) {
            throw new MojoExecutionException("JIRA does not support multiple data sources");
        }
    }

    @VisibleForTesting
    void updateDbConfigXml(File homeDir, JiraDatabaseType dbType, String schema) throws MojoExecutionException {
        String currentDbType;
        Document dbConfigDoc;
        File dbConfigXml = new File(homeDir, FILENAME_DBCONFIG);
        if (!dbConfigXml.exists() || dbType == null) {
            return;
        }
        SAXReader reader = new SAXReader();
        try {
            dbConfigDoc = reader.read(dbConfigXml);
        }
        catch (DocumentException de) {
            throw new MojoExecutionException("Cannot parse database configuration xml file", (Exception)((Object)de));
        }
        Node dbTypeNode = dbConfigDoc.selectSingleNode("//jira-database-config/database-type");
        Node schemaNode = dbConfigDoc.selectSingleNode("//jira-database-config/schema-name");
        boolean modified = false;
        if (null != dbTypeNode && StringUtils.isNotEmpty((CharSequence)dbTypeNode.getStringValue()) && !(currentDbType = dbTypeNode.getStringValue()).equals(dbType.getDbType())) {
            modified = true;
            dbTypeNode.setText(dbType.getDbType());
        }
        if (dbType.hasSchema()) {
            if (StringUtils.isEmpty((CharSequence)schema)) {
                throw new MojoExecutionException("Database configuration missed schema");
            }
            if (null == schemaNode) {
                try {
                    dbConfigDoc.selectSingleNode("//jira-database-config").getDocument().addElement("schema-name").addText(schema);
                    modified = true;
                }
                catch (NullPointerException npe) {
                    throw new MojoExecutionException(npe.getMessage());
                }
            } else if (StringUtils.isNotEmpty((CharSequence)schemaNode.getText()) && !schema.equals(schemaNode.getText())) {
                schemaNode.setText(schema);
                modified = true;
            }
        } else {
            schemaNode.detach();
            modified = true;
        }
        if (modified) {
            try {
                this.writeDbConfigXml(dbConfigXml, dbConfigDoc);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Could not write database configuration file: dbconfig.xml", (Exception)ioe);
            }
        }
    }

    private void writeDbConfigXml(File dbConfigXml, Document dbConfigDoc) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(dbConfigXml);){
            XMLWriter writer = new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint());
            writer.write(dbConfigDoc);
            writer.close();
        }
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product ctx) {
        String contextPath = ctx.getContextPath();
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        String baseUrl = ctx.getProtocol() + "://" + ctx.getServer() + ":" + ctx.getWebPort() + contextPath;
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(ctx);
        File homeDir = this.getHomeDirectory(ctx);
        replacements.add(0, new ConfigFileUtils.Replacement("http://localhost:8080", baseUrl, false));
        replacements.add(new ConfigFileUtils.Replacement("@project-dir@", homeDir.getParent(), false));
        replacements.add(new ConfigFileUtils.Replacement("/jira-home/", "/home/", false));
        replacements.add(new ConfigFileUtils.Replacement("@base-url@", baseUrl, false));
        replacements.add(new ConfigFileUtils.RegexReplacement("'[A-B]{1}[A-Z0-9]{3}-[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{4}'", "''"));
        return replacements;
    }

    @Override
    public List<File> getConfigFiles(Product product, File homeDir) {
        List<File> configFiles = super.getConfigFiles(product, homeDir);
        configFiles.add(new File(homeDir, "database.log"));
        configFiles.add(new File(homeDir, "database.script"));
        configFiles.add(new File(homeDir, FILENAME_DBCONFIG));
        return configFiles;
    }

    static void createDbConfigXmlIfNecessary(File homeDir) throws MojoExecutionException {
        File dbConfigXml = new File(homeDir, FILENAME_DBCONFIG);
        if (dbConfigXml.exists()) {
            return;
        }
        InputStream templateIn = JiraProductHandler.class.getResourceAsStream("jira-dbconfig-template.xml");
        if (templateIn == null) {
            throw new MojoExecutionException("Missing internal resource: jira-dbconfig-template.xml");
        }
        try {
            String template = IOUtils.toString((InputStream)templateIn, (String)"utf-8");
            File dbFile = JiraProductHandler.getHsqlDatabaseFile(homeDir);
            String jdbcUrl = "jdbc:hsqldb:file:" + dbFile.toURI().getPath();
            String result = template.replace("@jdbc-url@", jdbcUrl);
            org.apache.commons.io.FileUtils.writeStringToFile((File)dbConfigXml, (String)result, (String)"utf-8");
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to create config file: dbconfig.xml", (Exception)ioe);
        }
    }

    public List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    public List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File snapshotDir) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, snapshotDir);
        org.apache.commons.io.FileUtils.deleteQuietly((File)new File(snapshotDir, "log/atlassian-jira.log"));
    }

    private Collection<XmlOverride> serverXmlJiraOverride() {
        return Collections.unmodifiableList(Arrays.asList(new XmlOverride("conf/server.xml", "//Connector", "relaxedPathChars", "[]|"), new XmlOverride("conf/server.xml", "//Connector", "relaxedQueryChars", "[]|{}^\\`\"<>")));
    }

    private static class JiraPluginProvider
    extends AbstractPluginProvider {
        private JiraPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-jira-plugin", salVersion));
        }

        @Override
        protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
            ArrayList<ProductArtifact> plugins = new ArrayList<ProductArtifact>(super.getPdkInstallArtifacts(pdkInstallVersion));
            plugins.add(new ProductArtifact("commons-fileupload", "commons-fileupload", "1.2.1"));
            return plugins;
        }
    }
}

