/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerAwareMojo;
import com.atlassian.maven.plugins.amps.Application;
import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.product.AmpsDefaults;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.atlassian.maven.plugins.amps.util.ArtifactRetriever;
import com.atlassian.maven.plugins.amps.util.ProductHandlerUtil;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractProductHandlerMojo
extends AbstractProductHandlerAwareMojo {
    protected static final String JUNIT_VERSION = "4.12_1";
    protected static final String ATLASSIAN_TEST_RUNNER_VERSION = "2.0.2";
    protected static final String NO_TEST_GROUP = "__no_test_group__";
    public static final String JUNIT_GROUP_ID = "org.apache.servicemix.bundles";
    public static final String JUNIT_ARTIFACT_ID = "org.apache.servicemix.bundles.junit";
    public static final String TESTRUNNER_GROUP_ID = "com.atlassian.plugins";
    public static final String TESTRUNNER_ARTIFACT_ID = "atlassian-plugins-osgi-testrunner";
    public static final String TESTRUNNER_BUNDLE_ARTIFACT_ID = "atlassian-plugins-osgi-testrunner-bundle";
    public static final String DEFAULT_HTTPS_KEYSTOREFILE = "${user.home}/.keystore";
    public static final String DEFAULT_HTTPS_KEYSTOREPASS = "changeit";
    @Deprecated
    public static final String DEFAULT_HTTPS_KETSTOREPASS = "changeit";
    public static final String DEFAULT_HTTPS_KEYALIAS = "tomcat";
    public static final String DEFAULT_HTTP_SECURE = "true";
    public static final String DEFAULT_HTTPS_SSL_PROTOCOL = "TLS";
    public static final String DEFAULT_HTTPS_CLIENTAUTH = "false";
    public static final String DEFAULT_HTTPS_PORT = "0";
    private final List<ProductArtifact> testFrameworkPlugins = new ArrayList<ProductArtifact>();
    @Parameter(property="container")
    protected String containerId;
    @Parameter(property="customContainerArtifact")
    protected String customContainerArtifact;
    @Parameter(property="http.port", defaultValue="0")
    private int httpPort;
    @Parameter(property="ajp.port", defaultValue="8009")
    private int ajpPort;
    @Parameter(property="use.https", defaultValue="false")
    protected boolean useHttps;
    @Parameter(property="https.port", defaultValue="0")
    private int httpsPort;
    @Parameter(property="https.clientAuth", defaultValue="false")
    protected String httpsClientAuth;
    @Parameter(property="https.sslProtocol", defaultValue="TLS")
    protected String httpsSslProtocol;
    @Parameter(property="https.keystoreFile", defaultValue="${user.home}/.keystore")
    protected String httpsKeystoreFile;
    @Parameter(property="https.keystorePass", defaultValue="changeit")
    protected String httpsKeystorePass;
    @Parameter(property="https.keyAlias", defaultValue="tomcat")
    protected String httpsKeyAlias;
    @Parameter(property="https.httpSecure", defaultValue="true")
    protected boolean httpsHttpSecure;
    @Parameter(property="context.path")
    protected String contextPath;
    @Parameter(property="server")
    protected String server;
    @Parameter(property="product.version")
    private String productVersion;
    @Parameter(property="jvmargs")
    protected String jvmArgs;
    @Parameter(property="product.start.timeout")
    private int startupTimeout;
    @Parameter(property="product.stop.timeout")
    private int shutdownTimeout;
    @Deprecated
    @Parameter
    protected Properties systemProperties = new Properties();
    @Parameter
    protected Map<String, Object> systemPropertyVariables = new HashMap<String, Object>();
    @Parameter
    protected File log4jProperties;
    @Deprecated
    @Parameter(property="test.resources.version")
    private String testResourcesVersion;
    @Parameter(property="product.data.version")
    private String productDataVersion;
    @Parameter(property="product.data.path")
    private String productDataPath;
    @Parameter(property="product.data.overrides.path")
    private String productDataOverridesPath;
    @Parameter(property="devtoolbox.enable", defaultValue="true")
    protected boolean enableDevToolbox;
    @Parameter(property="devtoolbox.version", defaultValue="2.0.17")
    protected String devToolboxVersion;
    @Parameter(property="quickreload.enable", defaultValue="false")
    protected boolean enableQuickReload;
    @Parameter(property="quickreload.version", defaultValue="3.0.0")
    protected String quickReloadVersion;
    @Parameter(property="viewer.enable", defaultValue="false")
    protected boolean enablePluginViewer;
    @Parameter(property="viewer.version", defaultValue="1.0.4")
    protected String pluginViewerVersion;
    @Parameter(property="pde.enable", defaultValue="true")
    protected boolean enablePde;
    @Parameter(property="pde.version", defaultValue="1.2")
    protected String pdeVersion;
    @Parameter
    private List<Application> applications = new ArrayList<Application>();
    @Parameter
    private List<ProductArtifact> pluginArtifacts = new ArrayList<ProductArtifact>();
    @Parameter
    private List<ProductArtifact> libArtifacts = new ArrayList<ProductArtifact>();
    @Parameter
    private List<ProductArtifact> bundledArtifacts = new ArrayList<ProductArtifact>();
    @Deprecated
    @Parameter
    private String salVersion;
    @Deprecated
    @Parameter(defaultValue="0.6")
    private String pdkVersion;
    @Deprecated
    @Parameter
    private String restVersion;
    @Deprecated
    @Parameter(defaultValue="1.2.8")
    private String webConsoleVersion;
    @Parameter(property="plugins")
    private String pluginArtifactsString;
    @Parameter(property="lib.plugins")
    private String libArtifactsString;
    @Parameter(property="bundled.plugins")
    private String bundledArtifactsString;
    @Parameter(property="project.build.directory", required=true)
    protected File targetDirectory;
    @Parameter(property="project.build.finalName", required=true)
    protected String finalName;
    @Parameter(property="install.plugin", defaultValue="true")
    protected boolean installPlugin;
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    protected RepositoryMetadataManager repositoryMetadataManager;
    @Parameter(property="localRepository")
    protected ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories")
    protected List<ArtifactRepository> repositories;
    @Parameter
    protected List<Product> products = new ArrayList<Product>();
    private Map<String, Product> productMap;
    @Parameter
    private String output;
    @Parameter(property="additional.resource.folders")
    private String additionalResourceFolders;
    @Parameter(property="parallel", defaultValue="false")
    protected boolean parallel;
    @Parameter(property="await.full.initialization", defaultValue="true")
    protected boolean awaitFullInitialization;

    protected Product createDefaultProductContext() throws MojoExecutionException {
        Product ctx = new Product();
        ctx.setId(this.getProductId());
        ctx.setCustomContainerArtifact(this.customContainerArtifact);
        ctx.setContainerId(this.containerId);
        ctx.setServer(this.server);
        ctx.setContextPath(this.contextPath);
        ctx.setJvmArgs(this.jvmArgs);
        ctx.setStartupTimeout(this.startupTimeout);
        ctx.setShutdownTimeout(this.shutdownTimeout);
        HashMap<String, Object> properties = new HashMap<String, Object>(this.systemPropertyVariables);
        properties.put("atlassian.sdk.version", this.getAmpsPluginVersion());
        AbstractProductHandlerMojo.setDefaultSystemProperty(properties, "atlassian.dev.mode", DEFAULT_HTTP_SECURE);
        AbstractProductHandlerMojo.setDefaultSystemProperty(properties, "atlassian.allow.insecure.url.parameter.login", DEFAULT_HTTP_SECURE);
        AbstractProductHandlerMojo.setDefaultSystemProperty(properties, "java.awt.headless", DEFAULT_HTTP_SECURE);
        AbstractProductHandlerMojo.setDefaultSystemProperty(properties, "plugin.resource.directories", this.buildResourcesList());
        AbstractProductHandlerMojo.setDefaultSystemProperty(properties, "plugin.root.directories", this.buildRootProperty());
        ctx.setSystemPropertyVariables(properties);
        ctx.setBundledArtifacts(this.bundledArtifacts);
        ctx.setLibArtifacts(this.libArtifacts);
        ctx.setApplications(this.applications);
        ctx.setPluginArtifacts(this.pluginArtifacts);
        ctx.setLog4jProperties(this.log4jProperties);
        ctx.setHttpPort(this.httpPort);
        ctx.setAjpPort(this.ajpPort);
        ctx.setUseHttps(this.useHttps);
        ctx.setHttpsPort(this.httpsPort);
        ctx.setHttpsClientAuth(this.httpsClientAuth);
        ctx.setHttpsSSLProtocol(this.httpsSslProtocol);
        ctx.setHttpsKeystoreFile(this.httpsKeystoreFile);
        ctx.setHttpsKeystorePass(this.httpsKeystorePass);
        ctx.setHttpsKeyAlias(this.httpsKeyAlias);
        ctx.setHttpsHttpSecure(this.httpsHttpSecure);
        ctx.setVersion(this.productVersion);
        ctx.setDataVersion(this.productDataVersion);
        ctx.setDataPath(this.productDataPath);
        ctx.setDataOverridesPath(this.productDataOverridesPath);
        ctx.setRestVersion(this.restVersion);
        ctx.setSalVersion(this.salVersion);
        ctx.setPdkVersion(this.pdkVersion);
        ctx.setWebConsoleVersion(this.webConsoleVersion);
        ctx.setEnableQuickReload(this.enableQuickReload);
        ctx.setQuickReloadVersion(this.quickReloadVersion);
        ctx.setEnablePluginViewer(this.enablePluginViewer);
        ctx.setPluginViewerVersion(this.pluginViewerVersion);
        ctx.setEnableDevToolbox(this.enableDevToolbox);
        ctx.setDevToolboxVersion(this.devToolboxVersion);
        ctx.setEnablePde(this.enablePde);
        ctx.setPdeVersion(this.pdeVersion);
        ctx.setHttpPort(this.httpPort);
        ctx.setAwaitFullInitialization(this.awaitFullInitialization);
        return ctx;
    }

    private String buildResourcesList() {
        StringBuilder resourceProp = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.additionalResourceFolders)) {
            String[] dirs;
            for (String rDir : dirs = StringUtils.split((String)this.additionalResourceFolders, (String)",")) {
                File af = new File(rDir);
                if (!af.exists()) continue;
                resourceProp.append(StringUtils.trim((String)rDir)).append(",");
            }
        }
        MavenProject mavenProject = this.getMavenContext().getProject();
        List resList = mavenProject.getResources();
        for (int i = 0; i < resList.size(); ++i) {
            File rd = new File(((Resource)resList.get(i)).getDirectory());
            if (!rd.exists()) continue;
            resourceProp.append(((Resource)resList.get(i)).getDirectory());
            if (i + 1 == resList.size()) continue;
            resourceProp.append(",");
        }
        if (ProjectUtils.shouldDeployTestJar(this.getMavenContext())) {
            List testResList = mavenProject.getTestResources();
            for (int i = 0; i < testResList.size(); ++i) {
                if (i == 0 && resourceProp.length() > 0) {
                    resourceProp.append(",");
                }
                resourceProp.append(((Resource)testResList.get(i)).getDirectory());
                if (i + 1 == testResList.size()) continue;
                resourceProp.append(",");
            }
        }
        return resourceProp.toString();
    }

    private String buildRootProperty() {
        MavenProject mavenProject = this.getMavenContext().getProject();
        if (null != mavenProject && null != mavenProject.getBasedir()) {
            return mavenProject.getBasedir().getPath();
        }
        return "";
    }

    private static void setDefaultSystemProperty(Map<String, Object> props, String key, String value) {
        if (!props.containsKey(key)) {
            props.put(key, System.getProperty(key, value));
        }
    }

    protected void setDefaultValues(Product product, ProductHandler handler) {
        product.setDataVersion(System.getProperty("product.data.version", product.getDataVersion()));
        product.setVersion(System.getProperty("product.version", product.getVersion()));
        product.setDataPath(System.getProperty("product.data.path", product.getDataPath()));
        product.setInstanceId(this.getProductInstanceId(product));
        product.setArtifactRetriever(new ArtifactRetriever(this.artifactResolver, this.artifactFactory, this.localRepository, this.repositories, this.repositoryMetadataManager));
        if (this.containerIdNotDefinedOrProductSpecific(product)) {
            try {
                product.setContainerId(handler.getDefaultContainerId(product));
            }
            catch (MojoExecutionException e) {
                product.setContainerId(handler.getDefaultContainerId());
            }
            product.setContainerNotSpecified(true);
        }
        if (product.getServer() == null) {
            product.setServer(AmpsDefaults.DEFAULT_SERVER);
        }
        if (product.getPdkVersion() == null) {
            product.setPdkVersion("0.6");
        }
        if (product.getWebConsoleVersion() == null) {
            product.setWebConsoleVersion("1.2.8");
        }
        if (product.isEnableDevToolbox() == null) {
            product.setEnableDevToolbox(true);
        }
        if (product.getDevToolboxVersion() == null) {
            product.setDevToolboxVersion("2.0.17");
        }
        if (product.isEnableQuickReload() == null) {
            product.setEnableQuickReload(false);
        }
        if (product.getQuickReloadVersion() == null) {
            product.setQuickReloadVersion("3.0.0");
        }
        if (product.isEnablePluginViewer() == null) {
            product.setEnablePluginViewer(false);
        }
        if (product.getPluginViewerVersion() == null) {
            product.setPluginViewerVersion("1.0.4");
        }
        if (product.getPdeVersion() == null) {
            product.setPdeVersion("1.2");
        }
        if (product.getOutput() == null) {
            product.setOutput(this.output);
        }
        if (product.getStartupTimeout() <= 0) {
            product.setStartupTimeout(600000);
        }
        if (product.getShutdownTimeout() <= 0) {
            product.setShutdownTimeout(600000);
        }
        if (product.getHttpPort() == 0) {
            product.setHttpPort(handler.getDefaultHttpPort());
        }
        if (product.getUseHttps() == null) {
            product.setUseHttps(false);
        }
        if (product.getHttpsPort() == 0) {
            product.setHttpsPort(handler.getDefaultHttpsPort());
        }
        if (product.getHttpsClientAuth() == null) {
            product.setHttpsClientAuth(DEFAULT_HTTPS_CLIENTAUTH);
        }
        if (product.getHttpsSSLProtocol() == null) {
            product.setHttpsSSLProtocol(DEFAULT_HTTPS_SSL_PROTOCOL);
        }
        if (product.getHttpsKeystoreFile() == null) {
            product.setHttpsKeystoreFile(DEFAULT_HTTPS_KEYSTOREFILE);
        }
        if (product.getHttpsKeystorePass() == null) {
            product.setHttpsKeystorePass("changeit");
        }
        if (product.getHttpsKeyAlias() == null) {
            product.setHttpsKeyAlias(DEFAULT_HTTPS_KEYALIAS);
        }
        if (product.getHttpsHttpSecure() == null) {
            product.setHttpsHttpSecure(Boolean.parseBoolean(DEFAULT_HTTP_SECURE));
        }
        if (product.getVersion() == null) {
            product.setVersion("RELEASE");
        }
        if (product.getDataVersion() == null) {
            product.setDataVersion(product.getVersion());
        }
        if (product.getContextPath() == null) {
            product.setContextPath(handler.getDefaultContextPath());
        }
        if (product.getDataSources() == null) {
            product.setDataSources(new ArrayList<DataSource>());
        }
    }

    private boolean containerIdNotDefinedOrProductSpecific(Product product) {
        return product.getContainerId() == null || this.isProductSpecificContainerId(product);
    }

    private boolean isProductSpecificContainerId(Product product) {
        return "productSpecific".toUpperCase(Locale.ENGLISH).equals(product.getContainerId().toUpperCase(Locale.ENGLISH));
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.pluginArtifacts.addAll(ProductHandlerUtil.toArtifacts(this.pluginArtifactsString));
        this.libArtifacts.addAll(ProductHandlerUtil.toArtifacts(this.libArtifactsString));
        this.bundledArtifacts.addAll(ProductHandlerUtil.toArtifacts(this.bundledArtifactsString));
        this.systemPropertyVariables.putAll(this.systemProperties);
        this.detectDeprecatedVersionOverrides();
        this.doExecute();
    }

    public List<ProductArtifact> getTestFrameworkPlugins() {
        if (this.testFrameworkPlugins.isEmpty()) {
            String jUnitVersion = this.getMavenContext().getVersionOverrides().getProperty(JUNIT_ARTIFACT_ID, JUNIT_VERSION);
            this.testFrameworkPlugins.add(new ProductArtifact(JUNIT_GROUP_ID, JUNIT_ARTIFACT_ID, jUnitVersion));
            this.testFrameworkPlugins.add(new ProductArtifact(TESTRUNNER_GROUP_ID, TESTRUNNER_BUNDLE_ARTIFACT_ID, this.getTestRunnerVersion()));
        }
        return Collections.unmodifiableList(this.testFrameworkPlugins);
    }

    private String getTestRunnerVersion() {
        MavenContext mavenContext = this.getMavenContext();
        Properties overrides = mavenContext.getVersionOverrides();
        Artifact testRunnerDependency = ProjectUtils.getReactorArtifact(mavenContext, TESTRUNNER_GROUP_ID, TESTRUNNER_ARTIFACT_ID);
        String testRunnerVersion = Optional.ofNullable(testRunnerDependency).map(Artifact::getVersion).orElse(ATLASSIAN_TEST_RUNNER_VERSION);
        return overrides.getProperty(TESTRUNNER_BUNDLE_ARTIFACT_ID, testRunnerVersion);
    }

    private void detectDeprecatedVersionOverrides() {
        Properties props = this.getMavenContext().getProject().getProperties();
        for (String deprecatedProperty : new String[]{"sal.version", "rest.version", "web.console.version", "pdk.version"}) {
            if (!props.containsKey(deprecatedProperty)) continue;
            this.getLog().warn((CharSequence)("The property '" + deprecatedProperty + "' is no longer usable to override the related bundled plugin.  Use <pluginArtifacts> or <libArtifacts> to explicitly override bundled plugins and libraries, respectively."));
        }
    }

    private Map<String, Product> createProductContexts() throws MojoExecutionException {
        HashMap<String, Product> productContexts = new HashMap<String, Product>();
        MavenContext mavenContext = this.getMavenContext();
        MavenGoals goals = this.getMavenGoals();
        this.makeProductsInheritDefaultConfiguration(this.products, productContexts);
        for (Product ctx : new ArrayList(productContexts.values())) {
            ProductHandler handler = ProductHandlerFactory.create(ctx.getId(), mavenContext, goals, this.artifactFactory);
            this.setDefaultValues(ctx, handler);
        }
        return productContexts;
    }

    protected Map<String, Product> getProductContexts() throws MojoExecutionException {
        if (this.productMap == null) {
            this.productMap = this.createProductContexts();
        }
        return this.productMap;
    }

    void makeProductsInheritDefaultConfiguration(List<Product> products, Map<String, Product> productMap) throws MojoExecutionException {
        Product defaultProduct = this.createDefaultProductContext();
        productMap.put(this.getProductId(), defaultProduct);
        if (!products.isEmpty()) {
            for (Product product : products) {
                Product processedProduct = product.merge(defaultProduct);
                String instanceId = this.getProductInstanceId(processedProduct);
                productMap.put(instanceId, processedProduct);
            }
        }
    }

    private String getProductInstanceId(Product processedProduct) {
        return processedProduct.getInstanceId() == null ? processedProduct.getId() : processedProduct.getInstanceId();
    }

    protected void stopProducts(List<ProductExecution> productExecutions) throws MojoExecutionException {
        ExecutorService executor = Executors.newFixedThreadPool(productExecutions.size());
        try {
            long before = System.nanoTime();
            ArrayList<ProductExecution> reversed = new ArrayList<ProductExecution>(productExecutions);
            Collections.reverse(reversed);
            for (ProductExecution execution : reversed) {
                Product product = execution.getProduct();
                ProductHandler productHandler = execution.getProductHandler();
                Future<?> task = executor.submit(() -> {
                    this.getLog().info((CharSequence)(product.getInstanceId() + ": Shutting down"));
                    try {
                        productHandler.stop(product);
                    }
                    catch (MojoExecutionException e) {
                        this.getLog().error((CharSequence)("Exception while trying to stop " + product.getInstanceId()), (Throwable)e);
                    }
                });
                try {
                    task.get(product.getShutdownTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    this.getLog().info((CharSequence)(product.getInstanceId() + " shutdown: Didn't return in time"));
                    task.cancel(true);
                }
            }
            long after = System.nanoTime();
            this.getLog().info((CharSequence)("amps:stop in " + TimeUnit.NANOSECONDS.toSeconds(after - before) + "s"));
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("Exception while stopping the products", (Exception)e);
        }
        if (this.parallel) {
            this.waitForProducts(productExecutions, false);
        }
    }

    protected void waitForProducts(List<ProductExecution> productExecutions, boolean startingUp) throws MojoExecutionException {
        for (ProductExecution productExecution : productExecutions) {
            ProductHandlerUtil.pingRepeatedly(productExecution.getProduct(), startingUp, this.getLog());
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected void setParallelMode(List<ProductExecution> executions) {
        for (ProductExecution execution : executions) {
            Product product = execution.getProduct();
            if (this.parallel) {
                if (product.getSynchronousStartup() != null) continue;
                product.setSynchronousStartup(Boolean.FALSE);
                continue;
            }
            product.setSynchronousStartup(Boolean.TRUE);
        }
    }
}

