/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marshalling.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ClassPropertyBasedJsonSerializer
implements JsonSerializer<Object>,
JsonDeserializer<Object> {
    static final String CLASS_METADATA_PROPERTY_NOT_FOUND_IN_JSON = "Class Metadata property not found in Json";
    static final String JSON_ELEMENT_IS_NOT_JSON_OBJECT = "Json element is not a Json Object";
    private static final String CLASS_META_KEY = "CLASS_META_KEY";
    private static final String CONTENT = "CONTENT";

    public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (!jsonElement.isJsonObject()) {
            throw new JsonParseException(JSON_ELEMENT_IS_NOT_JSON_OBJECT);
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonElement classMetadataElement = jsonObject.get(CLASS_META_KEY);
        if (Objects.isNull(classMetadataElement)) {
            throw new JsonParseException(CLASS_METADATA_PROPERTY_NOT_FOUND_IN_JSON);
        }
        String className = classMetadataElement.getAsString();
        try {
            Class<?> clazz = Class.forName(className);
            return jsonDeserializationContext.deserialize(jsonObject.get(CONTENT), clazz);
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException("Could not instantiate class to deserialize json to", (Throwable)e);
        }
    }

    public JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        JsonElement jsonElement = jsonSerializationContext.serialize(object, object.getClass());
        jsonObject.addProperty(CLASS_META_KEY, object.getClass().getName());
        jsonObject.add(CONTENT, jsonElement);
        return jsonObject;
    }
}

