/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marshalling.gson;

import com.atlassian.marshalling.api.Marshaller;
import com.atlassian.marshalling.api.MarshallingException;
import com.atlassian.marshalling.api.Unmarshaller;
import com.atlassian.marshalling.jdk.StringMarshalling;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;

public abstract class BaseGsonMarshalling<T>
implements Marshaller<T>,
Unmarshaller<T> {
    private final Gson gson;
    private final TypeToken<T> typeToken;
    private final StringMarshalling stringMarshaller;

    protected BaseGsonMarshalling(Gson gson, TypeToken<T> typeToken) {
        this.gson = gson;
        this.typeToken = typeToken;
        this.stringMarshaller = new StringMarshalling();
    }

    public byte[] marshallToBytes(T t) throws MarshallingException {
        try {
            return this.stringMarshaller.marshallToBytes(this.gson.toJson(t, this.typeToken.getType()));
        }
        catch (JsonParseException e) {
            throw new MarshallingException("Unable to marshall", (Throwable)e);
        }
    }

    public T unmarshallFrom(byte[] bytes) throws MarshallingException {
        try {
            return (T)this.gson.fromJson(this.stringMarshaller.unmarshallFrom(bytes), this.typeToken.getType());
        }
        catch (JsonParseException e) {
            throw new MarshallingException("Unable to unmarshall", (Throwable)e);
        }
    }

    protected Gson getGson() {
        return this.gson;
    }

    protected TypeToken<T> getTypeToken() {
        return this.typeToken;
    }
}

