package com.atlassian.mail.msgraph.util;

import com.google.common.collect.ImmutableList;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Utility methods for Lists
 */
public class Lists {

    @SafeVarargs
    public static <T> List<T> concat(List<T>... xs) {
        return Arrays.stream(xs)
                .flatMap(List::stream)
                .collect(Collectors.toList());
    }

    /**
     * Prepends an element to an immutable list.
     */
    public static <T> List<T> prepend(T x, List<T> xs) {
        return ImmutableList.<T>builder()
                .add(x)
                .addAll(xs)
                .build();
    }
}
