package com.atlassian.mail.msgraph.settings.providers;

import com.atlassian.mail.msgraph.service.ExternalMailPuller;
import com.atlassian.mail.msgraph.service.MicrosoftGraphMailService;
import com.atlassian.mail.msgraph.settings.dto.MailSettingsDTO;
import io.atlassian.fugue.Option;

import java.util.function.Supplier;

import static io.atlassian.fugue.Option.some;

public class MicrosoftOAuthMailConnectionSettingsProvider extends BaseOAuthMailConnectionSettingsProvider {

    public MicrosoftOAuthMailConnectionSettingsProvider(
            MailSettingsDTO mailSettingsDTO,
            Supplier<Option<String>> authenticationTokenSupplier) {
        super(mailSettingsDTO, authenticationTokenSupplier);
    }

    @Override
    public Option<ExternalMailPuller> getHttpMailClient() {
        return some(new MicrosoftGraphMailService(this));
    }

}
