package com.atlassian.mail.server.impl;

import java.io.Serializable;

import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.AbstractMSGraphMailServer;
import com.atlassian.mail.server.MSGraphIncomingMailServer;
import com.atlassian.mail.server.auth.AuthenticationContext;

public class MSGraphIncomingMailServerImpl extends AbstractMSGraphMailServer
        implements MSGraphIncomingMailServer, Serializable {

    public MSGraphIncomingMailServerImpl(
            Long id,
            String name,
            String description,
            String host,
            String username,
            String port,
            long timeout,
            AuthenticationContext authenticationContext) {
        super(MailProtocol.MS_GRAPH, id, name, description, host, username, port, timeout, authenticationContext);
    }

    @Override
    public String getType() {
        return getMailProtocol().getMailServerType();
    }
}
