package com.atlassian.mail.server;

import java.io.PrintStream;
import java.util.Properties;
import javax.mail.Service;
import javax.mail.Session;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.auth.AuthenticationContext;
import com.atlassian.mail.server.auth.AuthenticationContextAware;

public abstract class AbstractMSGraphMailServer implements MailServer, AuthenticationContextAware {
    protected transient Logger log = LoggerFactory.getLogger(this.getClass());

    private Long id;
    private String name;
    private String host;
    private String description;
    private String username;
    private String port;
    private MailProtocol mailProtocol;
    private long timeout;
    private transient AuthenticationContext authenticationContext;

    public AbstractMSGraphMailServer(
            MailProtocol mailProtocol,
            Long id,
            String name,
            String description,
            String host,
            String username,
            String port,
            long timeout,
            AuthenticationContext authenticationContext) {
        this.mailProtocol = mailProtocol;
        this.id = id;
        this.name = name;
        this.description = description;
        this.host = host;
        this.username = username;
        this.port = port;
        this.timeout = timeout;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getHostname() {
        return host;
    }

    @Override
    public void setHostname(String hostname) {
        this.host = hostname;
    }

    @Override
    public String getUsername() {
        return username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPassword(String password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MailProtocol getMailProtocol() {
        return mailProtocol;
    }

    @Override
    public void setMailProtocol(MailProtocol mailProtocol) {
        this.mailProtocol = mailProtocol;
    }

    @Override
    public String getPort() {
        return port;
    }

    @Override
    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public long getTimeout() {
        return timeout;
    }

    @Override
    public String getSocksHost() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSocksPort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getDebug() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Session getSession() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setSocksHost(String socksHost) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSocksPort(String socksPort) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDebug(boolean debug) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDebugStream(PrintStream debugStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperties(Properties props) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties getProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLogger(Logger logger) {
        this.log = logger;
    }

    @Override
    public boolean isTlsHostnameCheckRequired() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTlsHostnameCheckRequired(boolean tlsHostnameCheckRequired) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAuthenticationContext(AuthenticationContext context) {
        this.authenticationContext = context;
    }

    @Override
    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    @Override
    public void smartConnect(Service service) {
        throw new UnsupportedOperationException();
    }
}
