package com.atlassian.mail.converters;

import java.io.IOException;
import javax.annotation.Nonnull;

/**
 * Basic interface for converting HTML string to other formats like plain text or wiki text.
 *
 * @since v2.6.0 was moved from <code>com.atlassian.mail.HtmlConverter</code>
 */
public interface HtmlConverter {
    /**
     * Do the convert.
     *
     * @param html input html
     * @return output format
     * @throws IOException from standard IO operations
     */
    String convert(@Nonnull String html) throws IOException;
}
