package com.atlassian.mail;

import io.atlassian.util.concurrent.ResettableLazyReference;

import com.atlassian.mail.config.ConfigLoader;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.auth.AuthenticationContextFactory;

public class MailFactory {
    /**
     * @deprecated since 2.5.0. Use {@link Settings#ATLASSIAN_MAIL_SEND_DISABLED_SYSTEM_PROPERTY_KEY} instead.
     */
    @Deprecated
    public static final String MAIL_DISABLED_KEY = "atlassian.mail.senddisabled";

    private static final ResettableLazyReference<ConfigLoader> configLoader =
            new ResettableLazyReference<ConfigLoader>() {
                @Override
                protected ConfigLoader create() throws Exception {
                    return ConfigLoader.getImmutableConfigurationLoader();
                }
            };

    public static void refresh() {
        configLoader.reset();
    }

    public static MailServerManager getServerManager() {
        return configLoader.get().getLoadedManager();
    }

    public static Settings getSettings() {
        return configLoader.get().getLoadedSettings();
    }

    public static AuthenticationContextFactory getAuthenticationContextFactory() {
        return configLoader.get().getLoadedAuthContextFactory();
    }

    /**
     * @return true if sending is disabled
     * @deprecated since 2.5.0. Use {@link com.atlassian.mail.Settings#isSendingDisabled()} instead
     */
    @Deprecated
    public static boolean isSendingDisabled() {
        return getSettings().isSendingDisabled();
    }
}
