/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.watch.nio.file.internal.java7;

import com.atlassian.watch.nio.file.api.Paths;
import com.atlassian.watch.nio.file.api.WatchEvent;
import com.atlassian.watch.nio.file.internal.Underlying;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.HashMap;
import java.util.Map;

public class WatchEventImpl<T>
implements com.atlassian.watch.nio.file.api.WatchEvent<T>,
Underlying<WatchEvent> {
    private final WatchEvent<T> impl;

    public WatchEventImpl(WatchEvent<T> impl) {
        this.impl = impl;
    }

    @Override
    public WatchEvent underlying() {
        return this.impl;
    }

    @Override
    public T context() {
        Path path = (Path)this.impl.context();
        return (T)(path == null ? null : Paths.toPath(path.toString()));
    }

    @Override
    public int count() {
        return this.impl.count();
    }

    @Override
    public WatchEvent.Kind<T> kind() {
        return KindImpl.unmap(this.impl.kind());
    }

    public boolean equals(Object obj) {
        return obj instanceof Underlying && this.impl.equals(((Underlying)obj).underlying());
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public String toString() {
        return this.impl.toString();
    }

    public static class ModifierImpl
    implements WatchEvent.Modifier,
    Underlying<WatchEvent.Modifier> {
        private final WatchEvent.Modifier impl;

        public ModifierImpl(WatchEvent.Modifier impl) {
            this.impl = impl;
        }

        static WatchEvent.Modifier map(WatchEvent.Modifier modifier) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public WatchEvent.Modifier underlying() {
            return this.impl;
        }

        @Override
        public String name() {
            return this.impl.name();
        }
    }

    public static class KindImpl
    implements WatchEvent.Kind,
    Underlying<WatchEvent.Kind> {
        private static Map<WatchEvent.Kind, WatchEvent.Kind> map = new HashMap<WatchEvent.Kind, WatchEvent.Kind>();
        private final WatchEvent.Kind impl;

        KindImpl(WatchEvent.Kind impl) {
            this.impl = impl;
        }

        static WatchEvent.Kind map(WatchEvent.Kind kind) {
            WatchEvent.Kind theKind = map.get(kind);
            if (theKind == null) {
                throw new IllegalStateException("Could find kind " + kind.name());
            }
            return theKind;
        }

        public static <T> WatchEvent.Kind<T> unmap(WatchEvent.Kind kind) {
            for (Map.Entry<WatchEvent.Kind, WatchEvent.Kind> entry : map.entrySet()) {
                if (entry.getValue() != kind) continue;
                return entry.getKey();
            }
            throw new IllegalStateException("Could find kind " + kind.name());
        }

        @Override
        public WatchEvent.Kind underlying() {
            return this.impl;
        }

        @Override
        public String name() {
            return this.impl.name();
        }

        public Class type() {
            return this.impl.type();
        }

        static {
            map.put(com.atlassian.watch.nio.file.api.StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_CREATE);
            map.put(com.atlassian.watch.nio.file.api.StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_DELETE);
            map.put(com.atlassian.watch.nio.file.api.StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_MODIFY);
            map.put(com.atlassian.watch.nio.file.api.StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.OVERFLOW);
        }
    }
}

