/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.restbrowser.servlet;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.labs.restbrowser.plugin.SoapService;
import com.atlassian.labs.restbrowser.provider.SoapServiceProvider;
import com.atlassian.labs.restbrowser.rest.model.RestDescriptor;
import com.atlassian.labs.restbrowser.servlet.RequiresLoginServlet;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class RestBrowserServlet
extends RequiresLoginServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestBrowserServlet.class);
    private static final String BROWSER_TEMPLATE = "/templates/browser.vm";
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final SoapServiceProvider soapServiceProvider;

    public RestBrowserServlet(PluginAccessor pluginAccessor, SoapServiceProvider soapServiceProvider, UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider, ApplicationProperties applicationProperties) {
        super(userManager, renderer, loginUriProvider);
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
        this.soapServiceProvider = Objects.requireNonNull(soapServiceProvider);
    }

    @Override
    protected Map<String, Object> getContext(HttpServletRequest req) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("applicationProperties", this.applicationProperties);
        context.put("devMode", System.getProperty("atlassian.dev.mode"));
        context.put("jsonRpcDescriptors", this.getJsonRpcDescriptors());
        context.put("restDescriptors", this.getRestDescriptors());
        return context;
    }

    @Override
    protected String getTemplatePath() {
        return BROWSER_TEMPLATE;
    }

    private List<RestDescriptor> getJsonRpcDescriptors() {
        return StreamSupport.stream(this.soapServiceProvider.getSoapServices().spliterator(), false).map(RestBrowserServlet::toRestDescriptor).collect(Collectors.toList());
    }

    private static RestDescriptor toRestDescriptor(SoapService soapService) {
        Plugin plugin = soapService.getPlugin();
        return new RestDescriptor.Builder().pluginKey(plugin.getKey()).pluginCompleteKey(soapService.getCompleteKey()).pluginName(plugin.getName()).pluginDescription(soapService.getDescription()).basePath("/json-rpc").version(soapService.getServicePath()).build();
    }

    private List<RestDescriptor> getRestDescriptors() {
        return this.pluginAccessor.getModuleDescriptors(RestBrowserServlet.describesRestModule()).stream().map(RestBrowserServlet::getRestDescriptor).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static <T> ModuleDescriptorPredicate<T> describesRestModule() {
        return md -> md != null && ("com.atlassian.plugins.rest.module.RestServletFilterModuleDescriptor".equals(md.getClass().getName()) || "com.atlassian.plugins.rest.v2.descriptor.RestServletFilterModuleDescriptor".equals(md.getClass().getName()));
    }

    private static Optional<RestDescriptor> getRestDescriptor(ModuleDescriptor<?> servlet) {
        String version;
        String basePath;
        Class[] params = new Class[]{};
        Object[] args = new Object[]{};
        try {
            Method getBasePath = servlet.getClass().getMethod("getBasePath", params);
            basePath = (String)getBasePath.invoke(servlet, args);
            Method getVersion = servlet.getClass().getMethod("getVersion", params);
            Object apiVersion = getVersion.invoke(servlet, args);
            version = apiVersion.toString();
        }
        catch (Exception e) {
            LOGGER.debug("Couldn't get REST module info from {}", servlet, (Object)e);
            return Optional.empty();
        }
        Plugin plugin = servlet.getPlugin();
        return Optional.of(new RestDescriptor.Builder().basePath(basePath).pluginCompleteKey(servlet.getCompleteKey()).pluginDescription(servlet.getDescription()).pluginKey(plugin.getKey()).pluginName(plugin.getName()).version(version).build());
    }
}

