/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.restbrowser.provider;

import com.atlassian.confluence.plugin.descriptor.rpc.SoapModuleDescriptor;
import com.atlassian.labs.restbrowser.plugin.AbstractSoapService;
import com.atlassian.labs.restbrowser.plugin.SoapService;
import com.atlassian.labs.restbrowser.provider.SoapServiceProvider;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;

public class ConfluenceSoapServiceProvider
implements SoapServiceProvider {
    private final PluginAccessor pluginAccessor;
    private final Function<SoapModuleDescriptor, ConfluenceSoapService> transformFunction = new Function<SoapModuleDescriptor, ConfluenceSoapService>(){

        public ConfluenceSoapService apply(SoapModuleDescriptor soapModuleDescriptor) {
            if (soapModuleDescriptor == null) {
                return null;
            }
            return new ConfluenceSoapService(soapModuleDescriptor);
        }
    };

    public ConfluenceSoapServiceProvider(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public Iterable<? extends SoapService> getSoapServices() {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(SoapModuleDescriptor.class);
        return Collections2.transform((Collection)moduleDescriptors, this.transformFunction);
    }

    private final class ConfluenceSoapService
    extends AbstractSoapService<SoapModuleDescriptor> {
        private ConfluenceSoapService(SoapModuleDescriptor moduleDescriptor) {
            this.moduleDescriptor = moduleDescriptor;
        }

        @Override
        public String getServicePath() {
            return ((SoapModuleDescriptor)this.moduleDescriptor).getServicePath();
        }

        @Override
        public Class<?> getPublishedInterface() {
            Class publishedInterface;
            try {
                publishedInterface = ((SoapModuleDescriptor)this.moduleDescriptor).getPublishedInterface();
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Couldn't get published interface from Confluence SOAP module descriptor", cnfe);
            }
            return publishedInterface;
        }
    }
}

