/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.restbrowser.rest.services;

import com.atlassian.labs.restbrowser.plugin.SoapService;
import com.atlassian.labs.restbrowser.provider.SoapServiceProvider;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/jsonrpc")
public class JsonRpcResource {
    private final PluginAccessor pluginAccessor;
    private final TemplateRenderer renderer;
    private final SoapServiceProvider soapServiceProvider;
    private final ApplicationProperties applicationProperties;
    private final Paranamer paranamer = new CachingParanamer();

    public JsonRpcResource(PluginAccessor pluginAccessor, TemplateRenderer renderer, SoapServiceProvider soapServiceProvider, ApplicationProperties applicationProperties) {
        this.pluginAccessor = pluginAccessor;
        this.renderer = renderer;
        this.soapServiceProvider = soapServiceProvider;
        this.applicationProperties = applicationProperties;
    }

    @GET
    @Path(value="/{pluginKey}/wadl")
    @Produces(value={"application/xml"})
    public Response getWadlForService(@PathParam(value="pluginKey") String pluginKey) throws IOException {
        Plugin plugin = this.pluginAccessor.getEnabledPlugin(pluginKey);
        if (plugin == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        HashMap context = Maps.newHashMap();
        ArrayList jsonRpcMethods = Lists.newArrayList();
        for (SoapService soapService : this.soapServiceProvider.getSoapServices()) {
            if (!soapService.getPluginKey().equals(pluginKey)) continue;
            StringBuilder resourceBase = new StringBuilder();
            resourceBase.append(this.applicationProperties.getBaseUrl());
            resourceBase.append("/rpc/json-rpc/");
            context.put("resourceBase", resourceBase.toString() + soapService.getServicePath());
            context.put("applicationProperties", this.applicationProperties);
            break;
        }
        StringWriter xmlContainer = new StringWriter();
        this.renderer.render("/templates/jsonrpc-wadl.vm", (Map)context, (Writer)xmlContainer);
        return Response.ok((Object)xmlContainer.toString()).build();
    }

    private String convertClassToXmlnsType(Class clazz) {
        String name = clazz.getSimpleName();
        if (name.equals("Long") || name.equals("Integer") || name.equals("Number")) {
            return "long";
        }
        return "string";
    }
}

