/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.rest;

import com.atlassian.labs.plugins.quickreload.SystemProperties;
import com.atlassian.labs.plugins.quickreload.rest.Links;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@AnonymousAllowed
@Produces(value={"application/json"})
@Consumes(value={"application/json", "text/plain", "application/x-www-form-urlencoded"})
@Path(value="/systemproperties")
public class SystemPropertiesResource {
    @GET
    public Response getProperties(@Context UriInfo uriInfo) {
        return this.ok(uriInfo);
    }

    @PUT
    @Path(value="{name}/{value : .+?}")
    public Response setProperty(@PathParam(value="name") String name, @PathParam(value="value") String value, @Context UriInfo uriInfo) {
        SystemProperties.setSystemProperty(name, value);
        return this.ok(uriInfo);
    }

    @GET
    @Path(value="{name}/{value : .+?}")
    public Response setPropertyAsGet(@PathParam(value="name") String name, @PathParam(value="value") String value, @Context UriInfo uriInfo) {
        return this.setProperty(name, value, uriInfo);
    }

    @PUT
    @Path(value="{name}")
    public Response setPropertyViaBody(@PathParam(value="name") String name, String value, @Context UriInfo uriInfo) {
        SystemProperties.setSystemProperty(name, value);
        return this.ok(uriInfo);
    }

    @DELETE
    @Path(value="{name}")
    public Response clearProperty(@PathParam(value="name") String name, @Context UriInfo uriInfo) {
        SystemProperties.clearSystemProperty(name);
        return this.ok(uriInfo);
    }

    private Response ok(UriInfo uriInfo) {
        return Response.ok((Object)new SystemPropertiesResponse(this.api(uriInfo), SystemProperties.getSystemProperties())).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private Links.ApiLinks api(UriInfo uriInfo) {
        return Links.ApiLinks.builder(uriInfo).build();
    }

    static class SystemPropertiesResponse {
        public final Map<String, String> properties;
        public final Links.ApiLinks api;

        public SystemPropertiesResponse(Links.ApiLinks api, Map<String, String> properties) {
            this.api = api;
            this.properties = properties;
        }
    }
}

