/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.rest;

import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;

class ResourceLink {
    public final String url;
    public final String method;
    public final String params;

    public ResourceLink(String method, String url, String params) {
        this.url = ResourceLink.replaceSpecials(url);
        this.method = method;
        this.params = params;
    }

    private static String replaceSpecials(String url) {
        url = StringUtils.replace((String)url, (String)"%7B", (String)"{");
        url = StringUtils.replace((String)url, (String)"%7D", (String)"}");
        return url;
    }

    public static ResourceLink get(String url) {
        return new ResourceLink("GET", url, null);
    }

    public static ResourceLink get(UriBuilder url) {
        return ResourceLink.get(url.build(new Object[0]).toASCIIString());
    }

    public static ResourceLink get(UriBuilder url, String ... params) {
        return new ResourceLink("GET", url.build(new Object[0]).toASCIIString(), ResourceLink.makeParams(params));
    }

    public static ResourceLink post(String url) {
        return new ResourceLink("POST", url, null);
    }

    public static ResourceLink post(UriBuilder url) {
        return ResourceLink.post(url.build(new Object[0]).toASCIIString());
    }

    public static ResourceLink delete(String url) {
        return new ResourceLink("DELETE", url, null);
    }

    public static ResourceLink delete(UriBuilder url) {
        return ResourceLink.delete(url.build(new Object[0]).toASCIIString());
    }

    public static ResourceLink put(String url) {
        return new ResourceLink("PUT", url, null);
    }

    public static ResourceLink put(UriBuilder url) {
        return ResourceLink.put(url.build(new Object[0]).toASCIIString());
    }

    private static String makeParams(String[] params) {
        StringBuilder sb = new StringBuilder();
        for (String param : params) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(param);
        }
        return sb.length() == 0 ? null : sb.toString();
    }
}

