/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.rest;

import com.atlassian.labs.plugins.quickreload.rest.ResourceLink;
import com.atlassian.labs.plugins.quickreload.utils.HttpKit;
import com.atlassian.labs.plugins.quickreload.utils.VersionKit;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public class Links {

    public static class ApiLinks {
        public final String qrVersion = VersionKit.getDisplayedVersion();
        public final ResourceLink self;
        public final ResourceLink api;
        public final ResourceLink bundles;
        public final ResourceLink plugins;
        public final ResourceLink services;
        public final ResourceLink events;
        public final ResourceLink systemproperties;
        public final ResourceLink systempropertiesPut;
        public final ResourceLink systempropertiesDelete;
        public final ResourceLink controlPanel;
        public final ResourceLink state;
        public final ResourceLink stateEnable;
        public final ResourceLink stateDisable;
        public final ResourceLink pluginInstall;
        public final ResourceLink pluginUninstall;
        public final ResourceLink pluginState;
        public final ResourceLink pluginEnable;
        public final ResourceLink pluginDisable;
        public final ResourceLink tracked;
        public final ResourceLink track;
        public final ResourceLink untrack;
        public final ResourceLink batching;
        public final ResourceLink batchingEnable;
        public final ResourceLink batchingDisable;
        public final ResourceLink batchingSetState;

        static Builder builder(UriInfo uriInfo) {
            return new Builder(uriInfo);
        }

        private ApiLinks(UriInfo uriInfo) {
            this.self = ResourceLink.get(uriInfo.getAbsolutePath().toASCIIString());
            this.api = ResourceLink.get(uriInfo.getBaseUriBuilder().path("api"));
            UriBuilder stateURL = uriInfo.getBaseUriBuilder().path("state");
            this.state = ResourceLink.get(stateURL);
            this.stateEnable = ResourceLink.put(stateURL);
            this.stateDisable = ResourceLink.delete(stateURL);
            this.pluginInstall = ResourceLink.post(uriInfo.getBaseUriBuilder().path("plugin/install/{fullJarPath}"));
            this.pluginUninstall = ResourceLink.delete(uriInfo.getBaseUriBuilder().path("plugin/install/{pluginKey}"));
            this.pluginState = ResourceLink.get(uriInfo.getBaseUriBuilder().path("plugin/enabled/{pluginOrModuleKey}"));
            this.pluginEnable = ResourceLink.post(uriInfo.getBaseUriBuilder().path("plugin/enabled/{pluginOrModuleKey}"));
            this.pluginDisable = ResourceLink.delete(uriInfo.getBaseUriBuilder().path("plugin/enabled/{pluginOrModuleKey}"));
            this.tracked = ResourceLink.get(uriInfo.getBaseUriBuilder().path("tracked"));
            this.track = ResourceLink.post(uriInfo.getBaseUriBuilder().path("tracked/{fullDirectoryPath}"));
            this.untrack = ResourceLink.delete(uriInfo.getBaseUriBuilder().path("tracked/{fullDirectoryPath}"));
            UriBuilder batchingURL = uriInfo.getBaseUriBuilder().path("batching");
            this.batching = ResourceLink.get(batchingURL);
            this.batchingEnable = ResourceLink.put(batchingURL);
            this.batchingDisable = ResourceLink.delete(batchingURL);
            UriBuilder batchingUpdateWithGetURL = uriInfo.getBaseUriBuilder().path("batching").path("setState");
            this.batchingSetState = ResourceLink.get(batchingUpdateWithGetURL, "?enabled={true|false}");
            this.bundles = ResourceLink.get(uriInfo.getBaseUriBuilder().path("bundles"));
            this.plugins = ResourceLink.get(uriInfo.getBaseUriBuilder().path("plugins"));
            this.services = ResourceLink.get(uriInfo.getBaseUriBuilder().path("services"));
            this.events = ResourceLink.get(uriInfo.getBaseUriBuilder().path("events"));
            UriBuilder sysPropURL = uriInfo.getBaseUriBuilder().path("systemproperties");
            this.systemproperties = ResourceLink.get(sysPropURL);
            this.systempropertiesPut = ResourceLink.put(sysPropURL.path("{name}").path("{value}"));
            this.systempropertiesDelete = ResourceLink.delete(sysPropURL.path("{name}"));
            this.controlPanel = ResourceLink.get(uriInfo.getBaseUriBuilder().replacePath(HttpKit.chopContextPathFromRestUrl(uriInfo)).path("/plugins/servlet/qr"));
        }

        static class Builder
        extends BasicLinkBuilder {
            private Builder(UriInfo uriInfo) {
                super(uriInfo);
            }

            ApiLinks build() {
                return new ApiLinks(this.uriInfo);
            }
        }
    }

    static class ModuleLinks {
        public final ResourceLink enabledState;
        public final ResourceLink enable;
        public final ResourceLink disable;
        public final ResourceLink pluginInfo;

        static Builder builder(UriInfo uriInfo) {
            return new Builder(uriInfo);
        }

        private ModuleLinks(String url, String pluginInfoUrl) {
            this.enabledState = ResourceLink.get(url);
            this.enable = ResourceLink.post(url);
            this.disable = ResourceLink.delete(url);
            this.pluginInfo = ResourceLink.get(pluginInfoUrl);
        }

        static class Builder
        extends BasicLinkBuilder {
            private String pluginKey;
            private String moduleKey;

            private Builder(UriInfo uriInfo) {
                super(uriInfo);
            }

            Builder withPluginKey(String pluginKey) {
                this.pluginKey = pluginKey;
                return this;
            }

            Builder withModuleKey(String moduleKey) {
                this.moduleKey = moduleKey;
                return this;
            }

            ModuleLinks build() {
                return new ModuleLinks(this.uriInfo.getBaseUriBuilder().path("plugin/enabled").path("{moduleKey}").build(new Object[]{this.moduleKey}).toASCIIString(), this.uriInfo.getBaseUriBuilder().path("plugins").path("{pluginKey}").build(new Object[]{this.pluginKey}).toASCIIString());
            }
        }
    }

    static class PluginLinks {
        public final ResourceLink enabledState;
        public final ResourceLink enable;
        public final ResourceLink disable;
        public final ResourceLink pluginInfo;

        static Builder builder(UriInfo uriInfo) {
            return new Builder(uriInfo);
        }

        private PluginLinks(String infoUrl, String enableUrl) {
            this.pluginInfo = ResourceLink.get(infoUrl);
            this.enabledState = ResourceLink.get(enableUrl);
            this.enable = ResourceLink.post(enableUrl);
            this.disable = ResourceLink.delete(enableUrl);
        }

        static class Builder
        extends BasicLinkBuilder {
            private String pluginKey;

            private Builder(UriInfo uriInfo) {
                super(uriInfo);
            }

            Builder withPluginKey(String pluginKey) {
                this.pluginKey = pluginKey;
                return this;
            }

            PluginLinks build() {
                return new PluginLinks(this.uriInfo.getBaseUriBuilder().path("plugins").path("{pluginKey}").build(new Object[]{this.pluginKey}).toASCIIString(), this.uriInfo.getBaseUriBuilder().path("plugin/enabled").path("{pluginKey}").build(new Object[]{this.pluginKey}).toASCIIString());
            }
        }
    }

    static class BundleLinks {
        public final String name;
        public final ResourceLink self;
        public final ResourceLink upmRepresentation;
        public final ResourceLink enabledState;
        public final ResourceLink enable;
        public final ResourceLink disable;

        static Builder builder(UriInfo uriInfo) {
            return new Builder(uriInfo);
        }

        private BundleLinks(String name, String self, String upmRepresentation, String enabledState) {
            this.name = name;
            this.self = ResourceLink.get(self);
            this.upmRepresentation = ResourceLink.get(upmRepresentation);
            this.enabledState = ResourceLink.get(enabledState);
            this.enable = ResourceLink.post(enabledState);
            this.disable = ResourceLink.delete(enabledState);
        }

        static class Builder
        extends BasicLinkBuilder {
            private long bundleId;
            private String pluginKey;
            private String name;

            private Builder(UriInfo uriInfo) {
                super(uriInfo);
            }

            Builder withName(String name) {
                this.name = name;
                return this;
            }

            Builder withBundleId(long bundleId) {
                this.bundleId = bundleId;
                return this;
            }

            Builder withPluginKey(String pluginKey) {
                this.pluginKey = pluginKey;
                return this;
            }

            BundleLinks build() {
                String context = HttpKit.chopContextPathFromRestUrl(this.uriInfo);
                return new BundleLinks(this.name, this.uriInfo.getBaseUriBuilder().path("bundles").path("{bundleId}").build(new Object[]{this.bundleId}).toASCIIString(), this.uriInfo.getBaseUriBuilder().replacePath(context).path("/rest/plugins/1.0/bundles/{bundleId}").build(new Object[]{this.bundleId}).toASCIIString(), this.uriInfo.getBaseUriBuilder().path("plugin/enabled").path("{pluginKey}").build(new Object[]{this.pluginKey}).toASCIIString());
            }
        }
    }

    private static class BasicLinkBuilder {
        protected final UriInfo uriInfo;

        private BasicLinkBuilder(UriInfo uriInfo) {
            this.uriInfo = uriInfo;
        }
    }
}

