/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.install;

import com.atlassian.labs.plugins.quickreload.WittyQuoter;
import com.atlassian.labs.plugins.quickreload.utils.LogLeveller;
import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginController;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PluginInstallerMechanic {
    private static final Logger log = LogLeveller.setInfo(LoggerFactory.getLogger(PluginInstallerMechanic.class));
    private static final Ansi.Color[] COLOUR_COLOURS = new Ansi.Color[]{Ansi.Color.BLUE, Ansi.Color.CYAN, Ansi.Color.GREEN, Ansi.Color.MAGENTA};
    private final PluginController pluginController;
    private final WittyQuoter wittyQuoter;
    private final PluginAccessor pluginAccessor;

    PluginInstallerMechanic(PluginController pluginController, WittyQuoter wittyQuoter, PluginAccessor pluginAccessor) {
        this.pluginController = pluginController;
        this.wittyQuoter = wittyQuoter;
        this.pluginAccessor = pluginAccessor;
    }

    void onShutdown() {
    }

    void enablePlugin(String pluginKey) {
        this.downArrowMsg(String.format("\n\n%sEnabling plugin(s) - '%s'....%s\n\n", this.boldYellow(), pluginKey, this.defaultColor()));
        this.pluginGuard(pluginKey, () -> {
            if (this.isModuleKey(pluginKey)) {
                this.pluginController.enablePluginModule(pluginKey);
            } else {
                this.pluginController.enablePlugins(new String[]{pluginKey});
            }
            return null;
        });
    }

    void disablePlugin(String pluginKey) {
        this.downArrowMsg(String.format("\n\n%sDisabling plugin(s) - '%s'....%s\n\n", this.boldYellow(), pluginKey, this.defaultColor()));
        this.pluginGuard(pluginKey, () -> {
            if (this.isModuleKey(pluginKey)) {
                this.pluginController.disablePluginModule(pluginKey);
            } else {
                this.pluginController.disablePlugin(pluginKey);
            }
            return null;
        });
    }

    boolean pluginEnabled(String pluginKey) {
        return this.pluginGuard(pluginKey, () -> {
            if (this.isModuleKey(pluginKey)) {
                return this.pluginAccessor.isPluginModuleEnabled(pluginKey);
            }
            return this.pluginAccessor.isPluginEnabled(pluginKey);
        }).orElse(Boolean.FALSE);
    }

    private boolean isModuleKey(String pluginKey) {
        return pluginKey.contains(":");
    }

    private void validPlugin(String pluginKey) {
        Object toCheck = this.isModuleKey(pluginKey) ? Boolean.valueOf(this.pluginAccessor.isPluginModuleEnabled(pluginKey)) : this.pluginAccessor.getPlugin(pluginKey);
        if (toCheck == null) {
            throw new IllegalArgumentException(String.format("The plugin or module with key '%s' can not be found", pluginKey));
        }
    }

    private <T> Optional<T> pluginGuard(String pluginKey, Supplier<T> supplier) {
        this.validPlugin(pluginKey);
        return Optional.ofNullable(supplier.get());
    }

    Optional<Exception> installPluginImmediately(File pluginFile) {
        long then = System.currentTimeMillis();
        String pluginPath = pluginFile.getAbsolutePath();
        this.downArrowMsg(String.format("\n\n%sStarting Quick Reload - '%s'....%s\n\n", this.boldYellow(), pluginPath, this.defaultColor()));
        JarPluginArtifact pluginArtifact = new JarPluginArtifact(pluginFile);
        Exception installException = null;
        try {
            this.pluginController.installPlugins(new PluginArtifact[]{pluginArtifact});
        }
        catch (Exception e) {
            installException = e;
        }
        long ms = System.currentTimeMillis() - then;
        StringBuilder sb = new StringBuilder();
        this.upArrow(sb);
        sb.append("\n\n");
        if (installException == null) {
            String wit = this.wittyQuoter.halfWit();
            Ansi.Color witColor = this.randomColor();
            String coloredWit = Ansi.ansi().fg(witColor) + wit + Ansi.ansi().fg(Ansi.Color.YELLOW);
            sb.append(String.format("\t\t%s\n\nQuick Reload Finished (%d ms) - '%s'", coloredWit, ms, pluginFile.getName()));
            this.notifyExternally(String.format("Quick Reload Finished - %s", wit));
        } else {
            sb.append(String.format("Quick Reload FAILED because of %s!!\n", installException));
        }
        sb.append(this.defaultColor());
        log.info(sb.toString());
        return Optional.ofNullable(installException);
    }

    private Ansi defaultColor() {
        return Ansi.ansi().boldOff().fg(Ansi.Color.DEFAULT);
    }

    private Ansi boldYellow() {
        return Ansi.ansi().bold().fg(Ansi.Color.YELLOW);
    }

    private void downArrowMsg(String msg) {
        StringBuilder sb = new StringBuilder();
        this.downArrow(sb);
        sb.append(msg);
        log.info(sb.toString());
    }

    private void notifyExternally(String msg) {
        try {
            Runtime.getRuntime().exec("quickreloadnotify '" + msg + "'");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Ansi.Color randomColor() {
        int index = new Random().nextInt(COLOUR_COLOURS.length);
        return COLOUR_COLOURS[index];
    }

    private void downArrow(StringBuilder sb) {
        this.makeArrow(sb, true);
    }

    private void upArrow(StringBuilder sb) {
        this.makeArrow(sb, false);
    }

    private void makeArrow(StringBuilder sb, boolean down) {
        String spacing = "\n\t\t\t\t\t\t";
        String lines = StringUtils.repeat((String)(spacing + "|"), (int)5);
        if (down) {
            sb.append(lines);
            sb.append(String.format("%sv", spacing));
        } else {
            sb.append(String.format("%s^", spacing));
            sb.append(lines);
        }
    }

    void uninstallPlugin(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("The plugin key %s can not be found", pluginKey));
        }
        this.pluginController.uninstall(plugin);
    }
}

