/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.install;

import com.atlassian.labs.plugins.quickreload.utils.Timer;
import java.io.File;

public class PluginInstallPromise {
    private final Timer timer;
    private final File pluginFile;
    private final long attempts;
    private final String fullPath;

    private PluginInstallPromise(long attempts, File pluginFile, Timer timer) {
        this.pluginFile = pluginFile;
        this.fullPath = pluginFile.getAbsolutePath();
        this.attempts = attempts;
        this.timer = timer;
    }

    public static PluginInstallPromise promise(File pluginFile) {
        return new PluginInstallPromise(0L, pluginFile, new Timer());
    }

    public static PluginInstallPromise retryFailureAgain(PluginInstallPromise promise) {
        return new PluginInstallPromise(promise.attempts + 1L, promise.pluginFile, promise.timer);
    }

    public File getPluginFile() {
        return this.pluginFile;
    }

    public long getAttempts() {
        return this.attempts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInstallPromise that = (PluginInstallPromise)o;
        return this.fullPath.equals(that.fullPath);
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }

    public String toString() {
        return super.toString() + " attempts : " + this.attempts + " : " + this.fullPath;
    }
}

