/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.inspectors;

import com.atlassian.labs.plugins.quickreload.inspectors.PluginBundle;
import com.atlassian.labs.plugins.quickreload.utils.ArrayKit;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.joor.Reflect;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.springframework.context.ApplicationContext;

@Named
public class BundleInspector {
    private static final Comparator<Bundle> BY_BUNDLE_ID = Comparator.comparingLong(Bundle::getBundleId);
    private static final Function<Object, String> TO_STRING_OR_NULL = from -> from == null ? null : from.toString();
    private static final Comparator<Object> BY_STRING_VALUE_OF = Comparator.comparing(String::valueOf);
    private static final String ATLASSIAN_PLUGIN_KEY = "Atlassian-Plugin-Key";
    private final BundleContext bundleContext;
    private final PluginAccessor pluginAccessor;

    @Inject
    public BundleInspector(BundleContext bundleContext, PluginAccessor pluginAccessor) {
        this.bundleContext = bundleContext;
        this.pluginAccessor = pluginAccessor;
    }

    public void inspectBundleServices(BundleServiceCallback callback) {
        HashSet seen = new HashSet();
        List<Bundle> bundles = ArrayKit.asList(this.bundleContext.getBundles());
        for (Bundle bundle : bundles) {
            List<ServiceRef> serviceRefs = this.inspectRegisteredServices(bundle);
            serviceRefs.stream().filter(serviceRef -> !seen.contains(serviceRef.serviceId)).forEach(serviceRef -> {
                seen.add(serviceRef.serviceId);
                callback.onBundle(this.newPluginBundle(bundle), (ServiceRef)serviceRef);
            });
        }
    }

    public void inspectBundles(BundleCallback bundleCallback) {
        Bundle[] b = this.bundleContext.getBundles();
        if (b == null || b.length == 0) {
            return;
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Collections.addAll(bundles, b);
        bundles.sort(BY_BUNDLE_ID);
        for (Bundle bundle : bundles) {
            PluginBundle pluginBundle = this.newPluginBundle(bundle);
            bundleCallback.onBundle(pluginBundle);
        }
    }

    public void inspectBundle(long bundleId, BeanCallback beanCallback) {
        Bundle bundle = this.bundleContext.getBundle(bundleId);
        if (bundle == null) {
            return;
        }
        PluginBundle pluginBundle = this.newPluginBundle(bundle);
        beanCallback.onStart(pluginBundle);
        List<ServiceReference> srs = this.getSpringContext(bundleId);
        for (ServiceReference sr : srs) {
            this.inspectSpringContext(beanCallback, this.bundleContext, sr);
        }
    }

    public Optional<Plugin> inspectBundlePluginModules(long bundleId, PluginCallback callback) {
        Bundle bundle = this.bundleContext.getBundle(bundleId);
        if (bundle == null) {
            return Optional.empty();
        }
        PluginBundle pluginBundle = this.newPluginBundle(bundle);
        Plugin plugin = this.pluginAccessor.getPlugin(pluginBundle.getPluginKey());
        if (plugin == null) {
            return Optional.empty();
        }
        for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
            callback.onModuleDescriptor(moduleDescriptor, this.pluginAccessor.isPluginModuleEnabled(moduleDescriptor.getCompleteKey()));
        }
        return Optional.of(plugin);
    }

    public boolean isSystemPlugin(Plugin plugin) {
        return this.pluginAccessor.isSystemPlugin(plugin.getKey());
    }

    public boolean isEnabled(Plugin plugin) {
        return this.pluginAccessor.isPluginEnabled(plugin.getKey());
    }

    public List<ServiceRef> inspectRegisteredServices(Bundle bundle) {
        List<ServiceReference> registeredSR = ArrayKit.asList(bundle.getRegisteredServices());
        return this.getServiceRefs(registeredSR);
    }

    public List<ServiceRef> inspectServicesInUse(Bundle bundle) {
        List<ServiceReference> registeredSR = ArrayKit.asList(bundle.getServicesInUse());
        return this.getServiceRefs(registeredSR);
    }

    private List<ServiceRef> getServiceRefs(List<ServiceReference> registeredSRs) {
        ArrayList<ServiceRef> serviceRefs = new ArrayList<ServiceRef>();
        for (ServiceReference serviceReference : registeredSRs) {
            List<Bundle> usingBundles = ArrayKit.asList(serviceReference.getUsingBundles());
            TreeMap<Object, String> properties = new TreeMap<Object, String>(BY_STRING_VALUE_OF);
            for (String name : serviceReference.getPropertyKeys()) {
                Object value = serviceReference.getProperty(name);
                properties.put(name, this.prettyServiceValue(value));
            }
            String serviceId = Optional.ofNullable(serviceReference.getProperty("service.id")).map(TO_STRING_OR_NULL).orElse("???");
            serviceRefs.add(new ServiceRef(serviceId, serviceReference.getBundle(), properties, usingBundles, this.makeObjectClasses(serviceReference)));
        }
        Collections.sort(serviceRefs);
        return serviceRefs;
    }

    private List<String> makeObjectClasses(ServiceReference serviceReference) {
        Object objectClass = serviceReference.getProperty("objectClass");
        ArrayList<String> objectClasses = new ArrayList<String>();
        if (objectClass != null) {
            if (objectClass instanceof String[]) {
                Collections.addAll(objectClasses, (String[])objectClass);
            } else {
                objectClasses.add(String.valueOf(objectClass));
            }
        }
        return objectClasses;
    }

    private String prettyServiceValue(Object value) {
        if (value instanceof String[]) {
            return String.join((CharSequence)",", (String[])value);
        }
        return String.valueOf(value);
    }

    private void inspectSpringContext(BeanCallback beanCallback, BundleContext bundleContext, ServiceReference sr) {
        Optional<ApplicationContext> springContext = Optional.ofNullable((ApplicationContext)bundleContext.getService(sr));
        if (springContext.isPresent()) {
            ApplicationContext applicationContext = springContext.get();
            beanCallback.onSpringContext(applicationContext);
            List<String> beanDefinitionNames = ArrayKit.asList(applicationContext.getBeanDefinitionNames());
            for (String beanName : beanDefinitionNames) {
                BeanInspectionDefinitionImpl bDef;
                try {
                    Object bean = applicationContext.getBean(beanName);
                    bDef = new BeanInspectionDefinitionImpl(beanName, applicationContext.isSingleton(beanName), applicationContext.isPrototype(beanName), bean);
                }
                catch (RuntimeException e) {
                    bDef = new BeanInspectionDefinitionImpl(beanName, e);
                }
                beanCallback.onSpringBean(bDef);
            }
        }
    }

    private List<ServiceReference> getSpringContext(long bundleId) {
        try {
            List<ServiceReference> fromList = ArrayKit.asList(this.bundleContext.getAllServiceReferences(ApplicationContext.class.getName(), null));
            return fromList.stream().filter(input -> input.getBundle().getBundleId() == bundleId).collect(Collectors.toList());
        }
        catch (InvalidSyntaxException e) {
            return Collections.emptyList();
        }
    }

    public PluginBundle newPluginBundle(Bundle bundle) {
        String pluginKey = BundleInspector.getPluginKey(bundle);
        return new PluginBundle(pluginKey, bundle, this.isAtlassianPlugin(pluginKey));
    }

    public Optional<PluginBundle> newPluginBundle(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            return Optional.empty();
        }
        Optional<Bundle> bundle = this.findBundle(plugin);
        return bundle.map(this::newPluginBundle);
    }

    private Optional<Bundle> findBundle(Plugin plugin) {
        String pluginKey = plugin.getKey();
        List<Bundle> bundles = ArrayKit.asList(this.bundleContext.getBundles());
        for (Bundle bundle : bundles) {
            if (!pluginKey.equals(BundleInspector.getPluginKey(bundle))) continue;
            return Optional.of(bundle);
        }
        return Optional.empty();
    }

    private boolean isAtlassianPlugin(String pluginKey) {
        return this.pluginAccessor.getPlugin(pluginKey) != null;
    }

    public String guessBeanClass(Object bean) {
        String className = bean.getClass().getName();
        if (className.startsWith("com.sun.proxy")) {
            try {
                Object h = Reflect.on((Object)bean).get("h");
                Object advised = Reflect.on((Object)h).get("advised");
                List interfaces = (List)Reflect.on((Object)advised).get("interfaces");
                if (interfaces != null && interfaces.size() > 0 && interfaces.get(0) != null) {
                    return ((Class)interfaces.get(0)).getName();
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return className;
    }

    public static String getPluginKey(Bundle bundle) {
        Optional<String> pluginKey = Optional.ofNullable(bundle.getHeaders().get(ATLASSIAN_PLUGIN_KEY)).map(TO_STRING_OR_NULL);
        if (pluginKey.isPresent()) {
            pluginKey = Optional.of(bundle.getSymbolicName());
        }
        return pluginKey.orElse("Unknown?? : " + bundle.getBundleId());
    }

    private static class BeanInspectionDefinitionImpl
    implements BeanInspectionDefinition {
        private final RuntimeException beanException;
        private final String beanName;
        private final Object bean;
        private final boolean singleton;
        private final boolean prototype;

        BeanInspectionDefinitionImpl(String beanName, boolean singleton, boolean prototype, Object bean) {
            this.beanException = null;
            this.beanName = beanName;
            this.bean = bean;
            this.singleton = singleton;
            this.prototype = prototype;
        }

        BeanInspectionDefinitionImpl(String beanName, RuntimeException beanException) {
            this.beanException = beanException;
            this.beanName = beanName;
            this.bean = null;
            this.singleton = false;
            this.prototype = false;
        }

        @Override
        public String beanName() {
            return this.beanName;
        }

        @Override
        public boolean singleton() {
            return this.singleton;
        }

        @Override
        public boolean prototype() {
            return this.prototype;
        }

        @Override
        public Optional<RuntimeException> beanException() {
            return Optional.ofNullable(this.beanException);
        }

        @Override
        public Optional<Object> bean() {
            return Optional.ofNullable(this.bean);
        }
    }

    public static class ServiceRef
    implements Comparable<ServiceRef> {
        public final String serviceId;
        public final Bundle offeringBundle;
        public final Map<String, String> serviceProperties;
        public final List<Bundle> usingBundles;
        public final List<String> objectClasses;

        ServiceRef(String serviceId, Bundle offeringBundle, Map<String, String> serviceProperties, List<Bundle> usingBundles, List<String> objectClasses) {
            this.serviceId = serviceId;
            this.offeringBundle = offeringBundle;
            this.objectClasses = objectClasses;
            this.serviceProperties = new HashMap<String, String>(serviceProperties);
            this.usingBundles = Collections.unmodifiableList(new ArrayList<Bundle>(usingBundles));
        }

        @Override
        public int compareTo(@Nonnull ServiceRef o) {
            return Integer.compare(this.toInt(this.serviceId), this.toInt(o.serviceId));
        }

        private int toInt(String id) {
            try {
                return Integer.parseInt(id);
            }
            catch (NumberFormatException e) {
                return Integer.MIN_VALUE;
            }
        }
    }

    public static interface PluginCallback {
        public void onModuleDescriptor(ModuleDescriptor<?> var1, boolean var2);
    }

    public static interface BundleServiceCallback {
        public void onBundle(PluginBundle var1, ServiceRef var2);
    }

    public static interface BundleCallback {
        public void onBundle(PluginBundle var1);
    }

    public static interface BeanCallback {
        public void onStart(PluginBundle var1);

        public void onSpringContext(ApplicationContext var1);

        public void onSpringBean(BeanInspectionDefinition var1);
    }

    public static interface BeanInspectionDefinition {
        public String beanName();

        public boolean singleton();

        public boolean prototype();

        public Optional<Object> bean();

        public Optional<RuntimeException> beanException();
    }
}

