/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.inspectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.osgi.framework.Bundle;

public class BundleHeaderParser {
    private static final Predicate<String> PARSED_HEADERS = Arrays.asList("Bundle-ClassPath", "Bundle-NativeCode", "Bundle-RequiredExecutionEnvironment", "DynamicImport-Package", "Export-Package", "Fragment-Host", "Ignore-Package", "Import-Package", "Private-Package", "Require-Bundle")::contains;
    static final Comparator<Object> BY_STRING_VALUE_OF = Comparator.comparing(String::valueOf);

    public static Map<String, String> getSimpleHeaders(Bundle bundle) {
        return BundleHeaderParser.sortedHeaders(bundle.getHeaders(), PARSED_HEADERS.negate());
    }

    private static Map<String, String> sortedHeaders(Dictionary headers, Predicate<String> suitableHeader) {
        TreeMap<Object, String> map = new TreeMap<Object, String>(BY_STRING_VALUE_OF);
        Enumeration keys = headers.keys();
        while (keys.hasMoreElements()) {
            String key = String.valueOf(keys.nextElement());
            if (!suitableHeader.test(key)) continue;
            map.put(key, String.valueOf(headers.get(key)));
        }
        return map;
    }

    public static Collection<ParsedHeader> getParseableHeaders(Bundle bundle) {
        ArrayList<ParsedHeader> headers = new ArrayList<ParsedHeader>();
        Map<String, String> suitableHeaders = BundleHeaderParser.sortedHeaders(bundle.getHeaders(), PARSED_HEADERS);
        for (String key : suitableHeaders.keySet()) {
            headers.add(BundleHeaderParser.parseHeader(key, suitableHeaders.get(key)));
        }
        return headers;
    }

    private static ParsedHeader parseHeader(String headerKey, String headerValue) {
        ManifestHeader manifestHeader = ManifestHeader.parse((String)headerValue);
        Collection<ParsedHeaderEntry> headerEntries = BundleHeaderParser.makeEntries(manifestHeader);
        return new ParsedHeader(headerKey, headerEntries);
    }

    private static Collection<ParsedHeaderEntry> makeEntries(ManifestHeader manifestValue) {
        ArrayList<ParsedHeaderEntry> entries = new ArrayList<ParsedHeaderEntry>();
        for (ManifestHeader.Entry entry : manifestValue.getEntries()) {
            entries.add(new ParsedHeaderEntry(entry.getValue(), BundleHeaderParser.toMap(entry.getAttributes()), BundleHeaderParser.toMap(entry.getDirectives())));
        }
        return entries;
    }

    private static Map<String, String> toMap(ManifestHeader.NameValuePair[] pairs) {
        if (pairs == null || pairs.length == 0) {
            return null;
        }
        HashMap<String, String> nvMap = new HashMap<String, String>();
        for (ManifestHeader.NameValuePair pair : pairs) {
            nvMap.put(pair.getName(), pair.getValue());
        }
        return nvMap;
    }

    public static class ParsedHeaderEntry {
        public final String path;
        public final Map<String, String> attributes;
        public final Map<String, String> directives;

        ParsedHeaderEntry(String path, Map<String, String> attributes, Map<String, String> directives) {
            this.path = path;
            this.attributes = attributes;
            this.directives = directives;
        }
    }

    public static class ParsedHeader {
        public final String name;
        public final Collection<ParsedHeaderEntry> entries;

        ParsedHeader(String name, Collection<ParsedHeaderEntry> entries) {
            this.name = name;
            this.entries = entries;
        }
    }
}

