/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BasicConfigFileReader {
    public List<String> readConfigFileEntries(File configFile) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!this.isSuitableEntry(line = StringUtils.trim((String)line))) continue;
                list.add(line);
            }
        }
        return list;
    }

    private boolean isSuitableEntry(String line) {
        return !this.isComment(line) && StringUtils.isNotBlank((CharSequence)line);
    }

    private boolean isComment(String line) {
        return StringUtils.startsWith((CharSequence)StringUtils.trim((String)line), (CharSequence)"#");
    }
}

