/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.config;

import com.atlassian.labs.plugins.quickreload.DirectoryTracker;
import com.atlassian.labs.plugins.quickreload.DirectoryWatcher;
import com.atlassian.labs.plugins.quickreload.LifecycledComponent;
import com.atlassian.labs.plugins.quickreload.StateManager;
import com.atlassian.labs.plugins.quickreload.SystemProperties;
import com.atlassian.labs.plugins.quickreload.WittyQuoter;
import com.atlassian.labs.plugins.quickreload.config.ConfigReader;
import com.atlassian.labs.plugins.quickreload.utils.LogLeveller;
import com.atlassian.labs.plugins.quickreload.utils.VersionKit;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AutoRefresher
implements LifecycledComponent {
    private static final Logger log = LogLeveller.setInfo(LoggerFactory.getLogger(AutoRefresher.class));
    private final DirectoryWatcher directoryWatcher;
    private final ConfigReader configReader;
    private final DirectoryTracker directoryTracker;
    private final WittyQuoter wittyQuoter;
    private final StateManager stateManager;

    @Inject
    public AutoRefresher(DirectoryWatcher directoryWatcher, ConfigReader configReader, DirectoryTracker directoryTracker, WittyQuoter wittyQuoter, StateManager stateManager) {
        this.directoryWatcher = directoryWatcher;
        this.configReader = configReader;
        this.directoryTracker = directoryTracker;
        this.wittyQuoter = wittyQuoter;
        this.stateManager = stateManager;
    }

    @Override
    public void onStartup() {
        this.directoryWatcher.watchSpecificFile(this.configReader.getHomeConfigurationFile(), this.onChange());
        List<File> localQRConfigFiles = this.configReader.getLocalQRConfigFiles();
        for (File localQRConfigFile : localQRConfigFiles) {
            this.directoryWatcher.watchSpecificFile(localQRConfigFile, this.onChange());
        }
        this.startupMessage();
    }

    private Function<File, Void> onChange() {
        return from -> {
            this.configReader.onRefresh();
            this.directoryWatcher.onRefresh();
            this.startupMessage();
            return null;
        };
    }

    private void startupMessage() {
        HashSet<String> alternateResourceDirs;
        StringBuilder sb = new StringBuilder();
        String version = VersionKit.getDisplayedVersion();
        sb.append(String.format("\n\n Quick Reload v%s - %s%s%s\n", version, this.ansiBlue(), this.wittyQuoter.halfWit(), this.ansiReset()));
        Set<File> tracked = this.directoryTracker.getTracked();
        if (!tracked.isEmpty()) {
            sb.append("\n\tTracking the following directories for changes : \n\n");
            for (File file : tracked) {
                sb.append(String.format("\t\t%s%s%s\n", this.ansiYellow(), file.getAbsolutePath(), this.ansiReset()));
            }
        }
        if (!(alternateResourceDirs = new HashSet<String>(SystemProperties.getSystemPropertySplit("plugin.resource.directories", ","))).isEmpty()) {
            sb.append(this.ansiYellow());
            sb.append(String.format("\n\tThe system property '%s' is as follows : \n\n", "plugin.resource.directories"));
            for (String resourceDir : alternateResourceDirs) {
                sb.append(String.format("\t\t%s%s%s\n", this.ansiYellow(), resourceDir, this.ansiReset()));
            }
            sb.append(this.ansiReset());
        }
        sb.append(String.format("\n\tThe Control Panel page is available at : \n\n\t\t%s/qr%s\n", this.ansiYellow(), this.ansiReset()));
        sb.append(String.format("\n\tThe REST API is available at : \n\n\t\t%s/rest/qr/api%s\n", this.ansiYellow(), this.ansiReset()));
        if (this.stateManager.isBatchingEnabled()) {
            sb.append(String.format("\n\tFast mode - web resource batching %senabled%s, 'atlassian.dev.mode' %sdisabled%s\n", this.ansiGreen(), this.ansiReset(), this.ansiRed(), this.ansiReset()));
        } else {
            sb.append(String.format("\n\tDev mode - web resource batching %sdisabled%s, 'atlassian.dev.mode' %senabled%s\n", this.ansiRed(), this.ansiReset(), this.ansiGreen(), this.ansiReset()));
        }
        log.info(sb.toString());
    }

    private Ansi ansiBlue() {
        return Ansi.ansi().fg(Ansi.Color.BLUE);
    }

    private Ansi ansiReset() {
        return Ansi.ansi().fg(Ansi.Color.DEFAULT);
    }

    private Ansi ansiYellow() {
        return Ansi.ansi().fg(Ansi.Color.YELLOW);
    }

    private Ansi ansiGreen() {
        return Ansi.ansi().fg(Ansi.Color.GREEN);
    }

    private Ansi ansiRed() {
        return Ansi.ansi().fg(Ansi.Color.RED);
    }

    @Override
    public void onShutdown() {
    }
}

