/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class SystemProperties {
    public static Map<String, String> getSystemProperties() {
        LinkedHashMap<String, String> propsAsStrings = new LinkedHashMap<String, String>();
        ArrayList<String> names = new ArrayList<String>(System.getProperties().stringPropertyNames());
        Collections.sort(names);
        names.stream().forEach(key -> propsAsStrings.put((String)key, System.getProperty(key)));
        return propsAsStrings;
    }

    public static void setSystemProperty(String key, String value) {
        System.setProperty(key, value);
    }

    public static void clearSystemProperty(String key) {
        Properties properties = System.getProperties();
        properties.remove(key);
    }

    public static Collection<String> getSystemPropertySplit(String systemProperty, String splitRegex) {
        String propertyValue = System.getProperty(systemProperty);
        ArrayList<String> set = new ArrayList<String>();
        if (propertyValue != null) {
            Collections.addAll(set, propertyValue.split(splitRegex));
        }
        return set;
    }

    public static String setSystemProperty(String systemProperty, Collection<String> values, char delimeter) {
        String newPropertyValue = StringUtils.join(values, (char)delimeter);
        System.setProperty(systemProperty, newPropertyValue);
        return newPropertyValue;
    }
}

