/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload;

import com.atlassian.labs.plugins.quickreload.DirectoryTracker;
import com.atlassian.labs.plugins.quickreload.DirectoryWatcher;
import com.atlassian.labs.plugins.quickreload.LifecycledComponent;
import com.atlassian.labs.plugins.quickreload.WittyQuoter;
import com.atlassian.labs.plugins.quickreload.config.AutoRefresher;
import com.atlassian.labs.plugins.quickreload.config.ConfigReader;
import com.atlassian.labs.plugins.quickreload.inspectors.EventInspector;
import com.atlassian.labs.plugins.quickreload.install.PluginInstaller;
import com.atlassian.labs.plugins.quickreload.utils.LogLeveller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class Launcher {
    private static final Logger log = LogLeveller.setInfo(LoggerFactory.getLogger(Launcher.class));
    private final Set<LifecycledComponent> lifecycled = new LinkedHashSet<LifecycledComponent>();
    private final DirectoryTracker directoryTracker;
    private final WittyQuoter wittyQuoter;

    @Inject
    public Launcher(DirectoryWatcher directoryWatcher, ConfigReader configReader, PluginInstaller pluginInstaller, DirectoryTracker directoryTracker, AutoRefresher autoRefresher, WittyQuoter wittyQuoter, EventInspector eventInspector) {
        this.wittyQuoter = wittyQuoter;
        this.add(wittyQuoter).add(configReader).add(directoryWatcher).add(pluginInstaller).add(autoRefresher).add(eventInspector);
        this.directoryTracker = directoryTracker;
    }

    private Launcher add(LifecycledComponent c) {
        this.lifecycled.add(c);
        return this;
    }

    @PostConstruct
    public void onPostConstruct() {
        AnsiConsole.systemInstall();
        for (LifecycledComponent component : this.lifecycled) {
            component.onStartup();
        }
    }

    @PreDestroy
    public void destroy() {
        ArrayList<LifecycledComponent> list = new ArrayList<LifecycledComponent>(this.lifecycled);
        Collections.reverse(list);
        for (LifecycledComponent component : list) {
            component.onShutdown();
        }
        AnsiConsole.systemUninstall();
    }
}

