/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.servlet;

import com.atlassian.labs.plugins.quickreload.DirectoryTracker;
import com.atlassian.labs.plugins.quickreload.Properties;
import com.atlassian.labs.plugins.quickreload.StateManager;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlPanelServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ControlPanelServlet.class);
    private SoyTemplateRenderer soyTemplateRenderer;
    private DirectoryTracker directoryTracker;
    private WebResourceManager webResourceManager;
    private StateManager stateManager;
    private Object apiLink;

    public ControlPanelServlet(SoyTemplateRenderer soyTemplateRenderer, DirectoryTracker directoryTracker, WebResourceManager webResourceManager, StateManager stateManager) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.directoryTracker = directoryTracker;
        this.webResourceManager = webResourceManager;
        this.stateManager = stateManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.webResourceManager.requireResource("com.atlassian.labs.plugins.quickreload.reloader:qr-control-panel-resources");
            this.soyTemplateRenderer.render((Appendable)response.getWriter(), "com.atlassian.labs.plugins.quickreload.reloader:qr-control-panel-resources", "QuickReload.Page.ControlPanel.main", this.getRenderParams(req));
        }
        catch (SoyException e) {
            log.error("Failed to render template for QuickReload control panel", (Throwable)e);
        }
    }

    private Map<String, Object> getRenderParams(HttpServletRequest req) {
        return ImmutableMap.builder().put((Object)"trackedDirectories", this.getTrackedDirectories()).put((Object)"trackedPluginResourceDirectories", this.getPluginResourceDirectories()).put((Object)"systemPropertyStates", this.getSystemPropertyStatesAsLists()).put((Object)"isProductionMode", (Object)this.stateManager.isBatchingEnabled()).put((Object)"apiLinkBase", (Object)this.getApiLink(req)).build();
    }

    private List<String> getTrackedDirectories() {
        ArrayList trackedDirectories = Lists.newArrayList();
        for (File trackedDirectory : this.directoryTracker.getTracked()) {
            trackedDirectories.add(trackedDirectory.getAbsolutePath());
        }
        return trackedDirectories;
    }

    private List<String> getPluginResourceDirectories() {
        return Lists.newArrayList(Properties.getSystemPropertySplit("plugin.resource.directories", ","));
    }

    private List<List<String>> getSystemPropertyStatesAsLists() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<String, String> entry : this.stateManager.getBatchingSystemPropertyStates().entrySet()) {
            builder.add((Object)Lists.newArrayList((Object[])new String[]{entry.getKey(), entry.getValue()}));
        }
        return builder.build();
    }

    public String getApiLink(HttpServletRequest req) {
        return String.format("%s://%s:%s%s/rest/qr/1.0", req.getScheme(), req.getServerName(), req.getServerPort(), req.getContextPath());
    }
}

