/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.rest;

import com.atlassian.labs.plugins.quickreload.inspectors.EventInspector;
import com.atlassian.labs.plugins.quickreload.rest.Links;
import com.atlassian.labs.plugins.quickreload.utils.ReflectionKit;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.format.ISODateTimeFormat;

@AnonymousAllowed
@Path(value="/events")
public class EventsResource {
    private final EventInspector eventInspector;

    @Inject
    public EventsResource(EventInspector eventInspector) {
        this.eventInspector = eventInspector;
    }

    @GET
    @AnonymousAllowed
    public Response getEventsPlural(@Context UriInfo uriInfo) {
        Events events = new Events(Links.ApiLinks.builder(uriInfo).build(), this.eventInspector.getCurrentEvents());
        return Response.ok((Object)events).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    static class Events {
        public final Collection<Event> events;
        public final Links.ApiLinks api;

        public Events(Links.ApiLinks api, Collection<EventInspector.Event> events) {
            this.api = api;
            this.events = Collections2.transform(events, (Function)new Function<EventInspector.Event, Event>(){

                public Event apply(EventInspector.Event from) {
                    return new Event(from);
                }
            });
        }
    }

    static class Event {
        public final String when;
        public final String eventClass;
        public final Map<String, String> event;

        Event(EventInspector.Event e) {
            this.when = ISODateTimeFormat.dateTime().print(e.getWhen());
            this.eventClass = e.getEvent().getClass().getName();
            this.event = ReflectionKit.asJsonMap(e.getEvent());
        }
    }
}

