/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.install;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.labs.plugins.quickreload.WittyQuoter;
import com.atlassian.labs.plugins.quickreload.utils.LogLeveller;
import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginException;
import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginInstallerMechanic {
    private static final Logger log = LogLeveller.setInfo(LoggerFactory.getLogger(PluginInstallerMechanic.class));
    private final PluginController pluginController;
    private final WittyQuoter wittyQuoter;
    private final PluginAccessor pluginAccessor;
    public static final Ansi.Color[] COLOUR_COLOURS = new Ansi.Color[]{Ansi.Color.BLUE, Ansi.Color.CYAN, Ansi.Color.GREEN, Ansi.Color.MAGENTA};

    public PluginInstallerMechanic(PluginController pluginController, WittyQuoter wittyQuoter, PluginAccessor pluginAccessor) {
        this.pluginController = pluginController;
        this.wittyQuoter = wittyQuoter;
        this.pluginAccessor = pluginAccessor;
    }

    public void onShutdown() {
    }

    public Option<? extends Exception> enablePlugin(final String pluginKey) {
        this.downArrowMsg(String.format("\n\n%sEnabling plugin(s) - '%s'....%s\n\n", this.boldYellow(), pluginKey, this.defaultColor()));
        return this.pluginGuard(pluginKey, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (PluginInstallerMechanic.this.isModuleKey(pluginKey)) {
                    PluginInstallerMechanic.this.pluginController.enablePluginModule(pluginKey);
                } else {
                    PluginInstallerMechanic.this.pluginController.enablePlugins(new String[]{pluginKey});
                }
                return null;
            }
        }).left().toOption();
    }

    public Option<? extends Exception> disablePlugin(final String pluginKey) {
        this.downArrowMsg(String.format("\n\n%sDisabling plugin(s) - '%s'....%s\n\n", this.boldYellow(), pluginKey, this.defaultColor()));
        return this.pluginGuard(pluginKey, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (PluginInstallerMechanic.this.isModuleKey(pluginKey)) {
                    PluginInstallerMechanic.this.pluginController.disablePluginModule(pluginKey);
                } else {
                    PluginInstallerMechanic.this.pluginController.disablePlugin(pluginKey);
                }
                return null;
            }
        }).left().toOption();
    }

    private boolean isModuleKey(String pluginKey) {
        return pluginKey.contains(":");
    }

    public Either<? extends Exception, Boolean> pluginEnabled(final String pluginKey) {
        return this.pluginGuard(pluginKey, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (PluginInstallerMechanic.this.isModuleKey(pluginKey)) {
                    return PluginInstallerMechanic.this.pluginAccessor.isPluginModuleEnabled(pluginKey);
                }
                return PluginInstallerMechanic.this.pluginAccessor.isPluginEnabled(pluginKey);
            }
        }).right().map(this.toBool());
    }

    private Function<? super Option<Boolean>, Boolean> toBool() {
        return new Function<Option<Boolean>, Boolean>(){

            public Boolean apply(Option<Boolean> from) {
                return (Boolean)from.getOrElse((Object)false);
            }
        };
    }

    private Option<? extends Exception> validPlugin(String pluginKey) {
        Object toCheck = this.isModuleKey(pluginKey) ? Boolean.valueOf(this.pluginAccessor.isPluginModuleEnabled(pluginKey)) : this.pluginAccessor.getPlugin(pluginKey);
        if (toCheck == null) {
            return Option.some((Object)new IllegalArgumentException(String.format("The plugin or module with key '%s' can not be found", pluginKey)));
        }
        return Option.none();
    }

    private <T> Either<? extends Exception, Option<T>> pluginGuard(String pluginKey, Callable<T> call) {
        Option<? extends Exception> option = this.validPlugin(pluginKey);
        if (option.isDefined()) {
            return Either.left((Object)option.get());
        }
        try {
            T t = call.call();
            return Either.right((Object)Option.option(t));
        }
        catch (Exception e) {
            return Either.left((Object)e);
        }
    }

    public Option<Exception> installPluginImmediately(File pluginFile) {
        long then = System.currentTimeMillis();
        String pluginPath = pluginFile.getAbsolutePath();
        this.downArrowMsg(String.format("\n\n%sStarting Quick Reload - '%s'....%s\n\n", this.boldYellow(), pluginPath, this.defaultColor()));
        JarPluginArtifact pluginArtifact = new JarPluginArtifact(pluginFile);
        Exception installException = null;
        try {
            this.pluginController.installPlugins(new PluginArtifact[]{pluginArtifact});
        }
        catch (Exception e) {
            installException = e;
        }
        long ms = System.currentTimeMillis() - then;
        StringBuilder sb = new StringBuilder();
        this.upArrow(sb);
        sb.append(String.format("\n\n", new Object[0]));
        Option rc = Option.option((Object)installException);
        if (rc.isEmpty()) {
            String wit = this.wittyQuoter.halfWit();
            Ansi.Color witColor = this.randomColor();
            String coloredWit = Ansi.ansi().fg(witColor) + wit + Ansi.ansi().fg(Ansi.Color.YELLOW);
            sb.append(String.format("\t\t%s\n\nQuick Reload Finished (%d ms) - '%s'", coloredWit, ms, pluginFile.getName()));
            this.notifyExternally(String.format("Quick Reload Finished - %s", wit));
        } else {
            sb.append(String.format("Quick Reload FAILED because of %s!!\n", rc.get()));
        }
        sb.append(this.defaultColor());
        log.info(sb.toString());
        return rc;
    }

    private Ansi defaultColor() {
        return Ansi.ansi().boldOff().fg(Ansi.Color.DEFAULT);
    }

    private Ansi boldYellow() {
        return Ansi.ansi().bold().fg(Ansi.Color.YELLOW);
    }

    private void downArrowMsg(String msg) {
        StringBuilder sb = new StringBuilder();
        this.downArrow(sb);
        sb.append(msg);
        log.info(sb.toString());
    }

    private void notifyExternally(String msg) {
        try {
            Runtime.getRuntime().exec("quickreloadnotify '" + msg + "'");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Ansi.Color randomColor() {
        int index = new Random().nextInt(COLOUR_COLOURS.length);
        return COLOUR_COLOURS[index];
    }

    private void downArrow(StringBuilder sb) {
        this.makeArrow(sb, true);
    }

    private void upArrow(StringBuilder sb) {
        this.makeArrow(sb, false);
    }

    private void makeArrow(StringBuilder sb, boolean down) {
        String spacing = "\n\t\t\t\t\t\t";
        String lines = StringUtils.repeat((String)(spacing + "|"), (int)5);
        if (down) {
            sb.append(lines);
            sb.append(String.format("%sv", spacing));
        } else {
            sb.append(String.format("%s^", spacing));
            sb.append(String.format(lines, new Object[0]));
        }
    }

    public Option<? extends Exception> uninstallPlugin(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            return Option.some((Object)new IllegalArgumentException(String.format("The plugin key %s can not be found", pluginKey)));
        }
        try {
            this.pluginController.uninstall(plugin);
        }
        catch (PluginException e) {
            return Option.some((Object)((Object)e));
        }
        return Option.none();
    }
}

