/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload;

import com.atlassian.fugue.Effect;
import com.atlassian.labs.plugins.quickreload.LifecycledComponent;
import com.atlassian.labs.plugins.quickreload.config.BasicConfigFileReader;
import com.atlassian.labs.plugins.quickreload.utils.Files;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.inject.Named;

@Named
public class WittyQuoter
implements LifecycledComponent {
    private static Random r = new Random();
    private static List<String> STATIC_WIT = Lists.newArrayList((Object[])new String[]{"A watched plugin never boils!", "Stealing back time from Maven since 2013.", "Just press up arrow!", "8 out of 10 women I asked about the shampoo they use in the shower said \"How the hell did you get in here!!\"", "If you can type on a Dvorak keyboard can you automatically speak Esperanto and program in Lisp?", "I have a hidden agenda...I cant find the bastard anywhere!", "If maven was a horse, you would shoot it, make it into dog food, feed it to a dog and then shoot that just to be certain!", "Waiting for Bamboo / JAC / EAC / Godot ..."});
    private List<String> trueWit = STATIC_WIT;

    public String halfWit() {
        int index = r.nextInt(this.trueWit.size() - 1);
        return this.trueWit.get(index);
    }

    @Override
    public void onStartup() {
        final ArrayList wit = Lists.newArrayList(STATIC_WIT);
        Files.traverseUpLookingForFile(".halfwit", Files.pwd(), new Effect<File>(){

            public void apply(File file) {
                wit.addAll(WittyQuoter.this.readWit(file));
            }
        });
        this.trueWit = wit;
    }

    private List<String> readWit(File witFile) {
        try {
            return new BasicConfigFileReader().readConfigFileEntries(witFile);
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
    }

    @Override
    public void onShutdown() {
    }
}

