/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload;

import com.atlassian.labs.plugins.quickreload.DirectoryTracker;
import com.atlassian.labs.plugins.quickreload.LifecycledComponent;
import com.atlassian.labs.plugins.quickreload.install.PluginInstaller;
import com.atlassian.labs.plugins.quickreload.utils.QuickReloadThreads;
import com.atlassian.watch.nio.file.api.FileSystems;
import com.atlassian.watch.nio.file.api.Path;
import com.atlassian.watch.nio.file.api.Paths;
import com.atlassian.watch.nio.file.api.StandardWatchEventKinds;
import com.atlassian.watch.nio.file.api.WatchEvent;
import com.atlassian.watch.nio.file.api.WatchKey;
import com.atlassian.watch.nio.file.api.WatchService;
import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DirectoryWatcher
implements LifecycledComponent {
    private static final Logger log = LoggerFactory.getLogger(DirectoryWatcher.class);
    private final ExecutorService exec;
    private final WatchService watchService;
    private final DirectoryTracker directoryTracker;
    private final PluginInstaller pluginInstaller;
    private final Map<WatchKey, Path> watchKeysToPaths;
    private final Map<File, WatchKey> directoriesToWatchKeys;
    private final Map<File, Function<File, Void>> specificFilesToWatch;
    private final Map<WatchKey, Path> watchKeysToParentPaths;
    private final Map<File, WatchKey> parentDirectoriesToWatchKeys;

    @Inject
    public DirectoryWatcher(DirectoryTracker directoryTracker, PluginInstaller pluginInstaller) {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.directoryTracker = directoryTracker;
        this.pluginInstaller = pluginInstaller;
        this.watchKeysToPaths = new HashMap<WatchKey, Path>();
        this.watchKeysToParentPaths = new HashMap<WatchKey, Path>();
        this.directoriesToWatchKeys = new HashMap<File, WatchKey>();
        this.parentDirectoriesToWatchKeys = new HashMap<File, WatchKey>();
        this.specificFilesToWatch = new HashMap<File, Function<File, Void>>();
        this.exec = QuickReloadThreads.singleThreadExecutorForClass(this.getClass());
    }

    @Override
    public void onStartup() {
        this.onRefresh();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                DirectoryWatcher.this.watchingThread();
            }
        };
        this.exec.execute(task);
    }

    @Override
    public void onShutdown() {
        try {
            this.watchService.close();
            this.exec.shutdown();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onRefresh() {
        for (File directory : this.directoryTracker.getTracked()) {
            this.watch(directory);
        }
    }

    public void watchSpecificFile(File f, Function<File, Void> callBack) {
        this.watch(f.getParentFile());
        this.specificFilesToWatch.put(f, callBack);
    }

    public void watch(File directory) {
        try {
            File parentFile;
            WatchKey key;
            Path watchPath;
            if (directory.exists() && directory.isDirectory()) {
                watchPath = Paths.toPath((String)directory.getCanonicalPath());
                key = watchPath.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY});
                this.watchKeysToPaths.put(key, watchPath);
                this.directoriesToWatchKeys.put(directory, key);
            }
            if ((parentFile = directory.getParentFile()) != null && parentFile.exists()) {
                watchPath = Paths.toPath((String)parentFile.getCanonicalPath());
                key = watchPath.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY});
                this.watchKeysToParentPaths.put(key, watchPath);
                this.parentDirectoriesToWatchKeys.put(parentFile, key);
            } else {
                log.warn(String.format("The parent directory of '%s' does not exist.  This file will not be watched for changes", directory));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void unwatch(File trackedDir) {
        WatchKey watchKey = this.directoriesToWatchKeys.get(trackedDir);
        if (watchKey != null) {
            this.watchKeysToPaths.remove(watchKey);
            this.directoriesToWatchKeys.remove(trackedDir);
            watchKey.cancel();
        }
        if ((watchKey = this.parentDirectoriesToWatchKeys.get(trackedDir.getParentFile())) != null) {
            this.parentDirectoriesToWatchKeys.remove(trackedDir.getParentFile());
            this.watchKeysToParentPaths.remove(watchKey);
            watchKey.cancel();
        }
    }

    private void watchingThread() {
        while (!this.exec.isShutdown()) {
            WatchKey signalledKey;
            try {
                signalledKey = this.watchService.take();
            }
            catch (Exception breakOut) {
                break;
            }
            List events = signalledKey.pollEvents();
            signalledKey.reset();
            Path parentPath = this.watchKeysToPaths.get(signalledKey);
            if (parentPath == null) {
                parentPath = this.watchKeysToParentPaths.get(signalledKey);
            }
            if (null == parentPath) continue;
            Set<ChangeType> changes = this.determineChangeTypes(events, parentPath);
            for (ChangeType change : changes) {
                File changedFile = change.file;
                this.checkForTrackedComingsAndGoings(change);
                Function<File, Void> callBack = this.specificFilesToWatch.get(changedFile);
                if (callBack != null) {
                    callBack.apply((Object)changedFile);
                }
                if (!this.directoryTracker.isTracked(changedFile.getParentFile())) continue;
                this.pluginInstaller.promiseToInstall(changedFile);
            }
        }
    }

    private Set<ChangeType> determineChangeTypes(List<WatchEvent<Path>> events, Path parentPath) {
        HashSet<ChangeType> changes = new HashSet<ChangeType>();
        for (WatchEvent<Path> e : events) {
            String dbgMsg = "";
            WatchEvent.Kind kind = e.kind();
            if (kind.equals(StandardWatchEventKinds.ENTRY_CREATE) || kind.equals(StandardWatchEventKinds.ENTRY_DELETE) || kind.equals(StandardWatchEventKinds.ENTRY_MODIFY)) {
                Path context = (Path)e.context();
                String fullPath = parentPath.toString() + "/" + context.toString();
                File changedFile = new File(fullPath);
                changes.add(new ChangeType(changedFile, kind));
                dbgMsg = kind.name() + " - " + fullPath + " - " + changedFile.length();
            } else if (kind.equals(StandardWatchEventKinds.OVERFLOW)) {
                dbgMsg = "OVERFLOW: more changes happened than we could retrieve";
            }
            if (!log.isDebugEnabled() || !StringUtils.isNotBlank((String)dbgMsg)) continue;
            log.debug(dbgMsg);
        }
        return changes;
    }

    private void checkForTrackedComingsAndGoings(ChangeType change) {
        File changedFile = change.file;
        if (this.directoryTracker.isTracked(changedFile)) {
            if (change.kind == StandardWatchEventKinds.ENTRY_DELETE) {
                WatchKey watchKey = this.directoriesToWatchKeys.get(changedFile);
                this.watchKeysToPaths.remove(watchKey);
            } else if (change.kind == StandardWatchEventKinds.ENTRY_CREATE) {
                this.watch(changedFile);
            }
        }
    }

    private static class ChangeType {
        private final File file;
        private final WatchEvent.Kind kind;

        private ChangeType(File file, WatchEvent.Kind kind) {
            this.file = file;
            this.kind = kind;
        }
    }
}

