/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.rest;

import com.atlassian.fugue.Pair;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;

class ResourceLink {
    public final String url;
    public final String method;
    public final String params;

    public ResourceLink(String method, String url, String params) {
        this.url = ResourceLink.replaceSpecials(url);
        this.method = method;
        this.params = params;
    }

    private static String replaceSpecials(String url) {
        url = StringUtils.replace((String)url, (String)"%7B", (String)"{");
        url = StringUtils.replace((String)url, (String)"%7D", (String)"}");
        return url;
    }

    public static ResourceLink get(String url) {
        return new ResourceLink("GET", url, null);
    }

    public static ResourceLink get(String url, Pair<String, String> ... params) {
        return new ResourceLink("GET", url, ResourceLink.makeParams(params));
    }

    public static ResourceLink get(UriBuilder url, Pair<String, String> ... params) {
        return ResourceLink.get(url.build(new Object[0]).toASCIIString(), params);
    }

    public static ResourceLink get(URI url, Pair<String, String> ... params) {
        return ResourceLink.get(url.toASCIIString(), params);
    }

    public static ResourceLink post(String url) {
        return new ResourceLink("POST", url, null);
    }

    public static ResourceLink post(String url, Pair<String, String> ... params) {
        return new ResourceLink("POST", url, ResourceLink.makeParams(params));
    }

    public static ResourceLink post(UriBuilder url, Pair<String, String> ... params) {
        return ResourceLink.post(url.build(new Object[0]).toASCIIString(), params);
    }

    public static ResourceLink post(URI url, Pair<String, String> ... params) {
        return ResourceLink.post(url.toASCIIString(), params);
    }

    public static ResourceLink delete(String url) {
        return new ResourceLink("DELETE", url, null);
    }

    public static ResourceLink delete(String url, Pair<String, String> ... params) {
        return new ResourceLink("DELETE", url, ResourceLink.makeParams(params));
    }

    public static ResourceLink delete(UriBuilder url, Pair<String, String> ... params) {
        return ResourceLink.delete(url.build(new Object[0]).toASCIIString(), params);
    }

    public static ResourceLink delete(URI url, Pair<String, String> ... params) {
        return ResourceLink.delete(url.toASCIIString(), params);
    }

    public static ResourceLink put(String url) {
        return new ResourceLink("PUT", url, null);
    }

    public static ResourceLink put(String url, Pair<String, String> ... params) {
        return new ResourceLink("PUT", url, ResourceLink.makeParams(params));
    }

    public static ResourceLink put(UriBuilder url, Pair<String, String> ... params) {
        return ResourceLink.put(url.build(new Object[0]).toASCIIString(), params);
    }

    public static ResourceLink put(URI url, Pair<String, String> ... params) {
        return ResourceLink.put(url.toASCIIString(), params);
    }

    private static String makeParams(Pair<String, String>[] params) {
        StringBuilder sb = new StringBuilder();
        for (Pair<String, String> param : params) {
            sb.append(" ").append((String)param.left()).append("=").append((String)param.right());
        }
        return sb.length() == 0 ? null : sb.toString();
    }
}

