/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.rest;

import com.atlassian.labs.plugins.quickreload.StateManager;
import com.atlassian.labs.plugins.quickreload.rest.Links;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@AnonymousAllowed
@Path(value="/state")
public class QuickReloadStateRestResource {
    private final StateManager stateManager;

    @Inject
    public QuickReloadStateRestResource(StateManager stateManager) {
        this.stateManager = stateManager;
    }

    @GET
    public Response state(@Context UriInfo uriInfo) {
        State state = new State(this.api(uriInfo), this.enabled());
        if (this.enabled()) {
            return Response.ok((Object)state).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)state).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private boolean enabled() {
        return this.stateManager.isQuickReloadEnabled();
    }

    @PUT
    public Response enable(@Context UriInfo uriInfo) {
        if (!this.enabled()) {
            this.stateManager.enableQuickReload();
        }
        State state = new State(this.api(uriInfo), this.enabled());
        return Response.ok((Object)state).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @DELETE
    public Response disable(@Context UriInfo uriInfo) {
        if (this.enabled()) {
            this.stateManager.disableQuickReload();
        }
        State state = new State(this.api(uriInfo), this.enabled());
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)state).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private Links.ApiLinks api(UriInfo uriInfo) {
        return Links.ApiLinks.builder(uriInfo).build();
    }

    static class State {
        public final boolean enabled;
        public final Links.ApiLinks api;

        public State(Links.ApiLinks api, boolean enabled) {
            this.api = api;
            this.enabled = enabled;
        }
    }
}

