/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.install;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.labs.plugins.quickreload.LifecycledComponent;
import com.atlassian.labs.plugins.quickreload.StateManager;
import com.atlassian.labs.plugins.quickreload.WittyQuoter;
import com.atlassian.labs.plugins.quickreload.install.PluginInstallPromise;
import com.atlassian.labs.plugins.quickreload.install.PluginInstallerMechanic;
import com.atlassian.labs.plugins.quickreload.install.StableJarPromise;
import com.atlassian.labs.plugins.quickreload.utils.Files;
import com.atlassian.labs.plugins.quickreload.utils.LogLeveller;
import com.atlassian.labs.plugins.quickreload.utils.QuickReloadThreads;
import com.atlassian.labs.plugins.quickreload.utils.Timer;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.File;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class PluginInstaller
implements LifecycledComponent {
    private static final Logger log = LogLeveller.setInfo(LoggerFactory.getLogger(PluginInstaller.class));
    public static final long HALF_A_SEC = TimeUnit.MILLISECONDS.toMillis(500L);
    public static final long A_TAD = TimeUnit.MILLISECONDS.toMillis(50L);
    public static final long MAX_STABILITY_WAIT_TIME = TimeUnit.SECONDS.toMillis(20L);
    public static final long ABSOLUTE_MAX_STABILITY_WAIT_TIME = TimeUnit.SECONDS.toMillis(60L);
    public static final long MAX_INSTALL_ATTEMPTS = 5L;
    private final StateManager stateManager;
    private final ExecutorService pluginInstallExecutor;
    private final ExecutorService stableFileExecutor;
    private final PluginInstallerMechanic pluginInstallerMechanic;
    private final ConcurrentLinkedQueue<PluginInstallPromise> installQueue;
    private final ConcurrentLinkedQueue<StableJarPromise> jarQueue;

    @Inject
    public PluginInstaller(@ComponentImport PluginController pluginController, @ComponentImport PluginAccessor pluginAccessor, WittyQuoter wittyQuoter, StateManager stateManager) {
        this.stateManager = stateManager;
        this.pluginInstallerMechanic = new PluginInstallerMechanic(pluginController, wittyQuoter, pluginAccessor);
        this.pluginInstallExecutor = QuickReloadThreads.singleThreadExecutorWithName("Plugin Installer");
        this.stableFileExecutor = QuickReloadThreads.singleThreadExecutorWithName("Stable File Watcher");
        this.installQueue = new ConcurrentLinkedQueue();
        this.jarQueue = new ConcurrentLinkedQueue();
    }

    @Override
    public void onStartup() {
        this.pluginInstallExecutor.submit(new Runnable(){

            @Override
            public void run() {
                PluginInstaller.this.loopWaitingForInstallPromises();
            }
        });
        this.stableFileExecutor.submit(new Runnable(){

            @Override
            public void run() {
                PluginInstaller.this.loopWaitingForStableFiles();
            }
        });
    }

    @Override
    public void onShutdown() {
        this.pluginInstallerMechanic.onShutdown();
        this.pluginInstallExecutor.shutdown();
        this.stableFileExecutor.shutdown();
        this.kickJarQueue();
        this.kickInstallQueue();
    }

    public Option<? extends Exception> enablePlugin(String pluginKey) {
        return this.pluginInstallerMechanic.enablePlugin(pluginKey);
    }

    public Option<? extends Exception> disablePlugin(String pluginKey) {
        return this.pluginInstallerMechanic.disablePlugin(pluginKey);
    }

    public Either<? extends Exception, Boolean> pluginEnabled(String pluginKey) {
        return this.pluginInstallerMechanic.pluginEnabled(pluginKey);
    }

    public boolean smellsLikePlugin(File candidate) {
        return candidate.exists() && candidate.getName().endsWith(".jar");
    }

    public void promiseToInstall(File candidatePlugin) {
        StableJarPromise stableJarPromise;
        if (this.smellsLikePlugin(candidatePlugin) && !this.jarQueue.contains(stableJarPromise = new StableJarPromise(candidatePlugin, new Timer()))) {
            this.info(String.format("Changes noticed in '%s'...", candidatePlugin.getAbsolutePath()), new Object[0]);
            this.jarQueue.offer(stableJarPromise);
        }
    }

    private void loopWaitingForStableFiles() {
        while (!this.stableFileExecutor.isShutdown()) {
            StableJarPromise jarFilePromise;
            LinkedList<StableJarPromise> stillUnstableJars = new LinkedList<StableJarPromise>();
            while ((jarFilePromise = this.jarQueue.poll()) != null) {
                File jarFile = jarFilePromise.getPluginFile();
                if (this.waitUntilFileIsStableFor(HALF_A_SEC, MAX_STABILITY_WAIT_TIME, jarFile)) {
                    if (Files.isAtlassianPlugin(jarFile)) {
                        PluginInstallPromise pluginInstallPromise = PluginInstallPromise.promise(jarFile);
                        if (this.installQueue.contains(pluginInstallPromise)) continue;
                        this.info(String.format("'%s' is indeed an Atlassian plugin and will be installed shortly...", jarFile.getName()), new Object[0]);
                        this.installQueue.offer(pluginInstallPromise);
                        this.kickInstallQueue();
                        continue;
                    }
                    this.info(String.format("'%s' is not an Atlassian plugin after all.  Ignoring...", jarFile.getName()), new Object[0]);
                    continue;
                }
                stillUnstableJars.add(jarFilePromise);
            }
            for (StableJarPromise stillUnstable : stillUnstableJars) {
                if (stillUnstable.getTimer().hasElapsed(ABSOLUTE_MAX_STABILITY_WAIT_TIME, TimeUnit.MILLISECONDS)) {
                    this.info(String.format("Abandoning '%s' because it did not become stable in %d seconds", stillUnstable.getPluginFile(), TimeUnit.MILLISECONDS.toSeconds(ABSOLUTE_MAX_STABILITY_WAIT_TIME)), new Object[0]);
                    continue;
                }
                this.jarQueue.offer(stillUnstable);
            }
            if (this.waitOnQueue(this.jarQueue, HALF_A_SEC)) continue;
            return;
        }
    }

    private void loopWaitingForInstallPromises() {
        while (!this.pluginInstallExecutor.isShutdown()) {
            PluginInstallPromise installPromise;
            LinkedList<PluginInstallPromise> retryLater = new LinkedList<PluginInstallPromise>();
            while ((installPromise = this.installQueue.poll()) != null) {
                Option<Exception> installAttempt = this.attemptInstall(installPromise);
                if (!installAttempt.isDefined()) continue;
                if (installPromise.getAttempts() > 5L) {
                    this.info(String.format("Failed to install '%s' after %d attempts.  I am giving up!!", installPromise.getPluginFile(), 5L), new Object[0]);
                    continue;
                }
                this.info(String.format("Failed to install '%s' because of '%s'. I will retry in a short while.", installPromise.getPluginFile(), ((Exception)installAttempt.get()).getMessage()), new Object[0]);
                PluginInstallPromise retryPromise = PluginInstallPromise.retryFailureAgain(installPromise);
                this.dbg("Will retry this promise %s", retryPromise);
                retryLater.add(retryPromise);
            }
            for (PluginInstallPromise missedPlugin : retryLater) {
                this.installQueue.offer(missedPlugin);
            }
            if (this.waitOnQueue(this.installQueue, HALF_A_SEC)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitOnQueue(Object queue, long nextWaitTime) {
        try {
            this.dbg("Waiting on queue for %d", nextWaitTime);
            Object object = queue;
            synchronized (object) {
                queue.wait(Math.max(nextWaitTime, 1L));
            }
        }
        catch (InterruptedException e) {
            this.dbg("Thread interruption exception during wait", new Object[0]);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kickInstallQueue() {
        ConcurrentLinkedQueue<PluginInstallPromise> concurrentLinkedQueue = this.installQueue;
        synchronized (concurrentLinkedQueue) {
            this.installQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kickJarQueue() {
        ConcurrentLinkedQueue<StableJarPromise> concurrentLinkedQueue = this.jarQueue;
        synchronized (concurrentLinkedQueue) {
            this.jarQueue.notifyAll();
        }
    }

    private Option<Exception> attemptInstall(PluginInstallPromise promise) {
        File pluginFile = promise.getPluginFile();
        if (!pluginFile.exists()) {
            this.info(String.format("'%s' has disappeared just as I was trying to install it.", pluginFile), new Object[0]);
        }
        return this.installPluginImmediately(pluginFile);
    }

    public Option<Exception> installPluginImmediately(File pluginFile) {
        if (!this.stateManager.isQuickReloadEnabled()) {
            this.info(String.format("QuickReload is currently disabled....'%s' will not be installed", pluginFile), new Object[0]);
            return Option.none();
        }
        return this.pluginInstallerMechanic.installPluginImmediately(pluginFile);
    }

    public Option<? extends Exception> uninstallPlugin(String pluginKey) {
        if (!this.stateManager.isQuickReloadEnabled()) {
            this.info(String.format("QuickReload is currently disabled....'%s' will not be un-installed", pluginKey), new Object[0]);
            return Option.none();
        }
        return this.pluginInstallerMechanic.uninstallPlugin(pluginKey);
    }

    private boolean waitUntilFileIsStableFor(long stableForMS, long maxWaitMS, File candidate) {
        Timer startTimer = new Timer();
        Timer msgTimer = new Timer();
        Timer stableTimer = new Timer();
        long prevLen = candidate.length();
        String fileName = candidate.getName();
        this.info(String.format("Waiting for '%s' to become stable (%d bytes)...", fileName, prevLen), new Object[0]);
        while (startTimer.isInside(maxWaitMS) && !this.pluginInstallExecutor.isShutdown()) {
            this.sleepFor(A_TAD);
            long newLen = candidate.length();
            if (newLen == prevLen) {
                if (stableTimer.hasElapsed(stableForMS)) {
                    this.info(String.format("'%s' now appears to be stable (%d bytes)", fileName, prevLen), new Object[0]);
                    return true;
                }
            } else {
                prevLen = newLen;
                stableTimer.reset();
            }
            if (!msgTimer.hasElapsed(3L, TimeUnit.SECONDS)) continue;
            this.info(String.format("Waiting for the plugin file to become stable (%d bytes)...", prevLen), new Object[0]);
            msgTimer.reset();
        }
        this.info(String.format("Plugin file has not become stable in %d seconds", TimeUnit.MILLISECONDS.toSeconds(maxWaitMS)), new Object[0]);
        return false;
    }

    private void sleepFor(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ignored) {
            throw new RuntimeException(ignored);
        }
    }

    private void dbg(String msgFormat, Object ... params) {
        if (log.isDebugEnabled()) {
            log.debug(String.format(msgFormat, params));
        }
    }

    private void info(String msgFormat, Object ... params) {
        if (log.isInfoEnabled()) {
            log.info(Ansi.ansi().fg(Ansi.Color.YELLOW) + String.format(msgFormat, params) + Ansi.ansi().fg(Ansi.Color.DEFAULT));
        }
    }
}

