/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.inspectors;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.osgi.framework.Bundle;

public class BundleHeaderParser {
    private static final Predicate<String> PARSED_HEADERS = Predicates.in((Collection)ImmutableSet.copyOf((Object[])new String[]{"Bundle-ClassPath", "Bundle-NativeCode", "Bundle-RequiredExecutionEnvironment", "DynamicImport-Package", "Export-Package", "Fragment-Host", "Ignore-Package", "Import-Package", "Private-Package", "Require-Bundle"}));
    static final Comparator<Object> BY_STRING_VALUE_OF = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return String.valueOf(o1).compareTo(String.valueOf(o2));
        }
    };

    public static Map<String, String> getSimpleHeaders(Bundle bundle) {
        return BundleHeaderParser.sortedHeaders(bundle.getHeaders(), (Predicate<String>)Predicates.not(PARSED_HEADERS));
    }

    private static Map<String, String> sortedHeaders(Dictionary headers, Predicate<String> suitableHeader) {
        TreeMap map = Maps.newTreeMap(BY_STRING_VALUE_OF);
        Enumeration keys = headers.keys();
        while (keys.hasMoreElements()) {
            String key = String.valueOf(keys.nextElement());
            if (!suitableHeader.apply((Object)key)) continue;
            map.put(key, String.valueOf(headers.get(key)));
        }
        return map;
    }

    public static Collection<ParsedHeader> getParseableHeaders(Bundle bundle) {
        ArrayList headers = Lists.newArrayList();
        Map<String, String> suitableHeaders = BundleHeaderParser.sortedHeaders(bundle.getHeaders(), PARSED_HEADERS);
        for (String key : suitableHeaders.keySet()) {
            headers.add(BundleHeaderParser.parseHeader(key, suitableHeaders.get(key)));
        }
        return headers;
    }

    private static ParsedHeader parseHeader(String headerKey, String headerValue) {
        ManifestHeader manifestHeader = ManifestHeader.parse((String)headerValue);
        Collection<ParsedHeaderEntry> headerEntries = BundleHeaderParser.makeEntries(manifestHeader);
        return new ParsedHeader(headerKey, headerEntries);
    }

    private static Collection<ParsedHeaderEntry> makeEntries(ManifestHeader manifestValue) {
        ArrayList entries = Lists.newArrayList();
        for (ManifestHeader.Entry entry : manifestValue.getEntries()) {
            entries.add(new ParsedHeaderEntry(entry.getValue(), BundleHeaderParser.toMap(entry.getAttributes()), BundleHeaderParser.toMap(entry.getDirectives())));
        }
        return entries;
    }

    private static Map<String, String> toMap(ManifestHeader.NameValuePair[] pairs) {
        if (pairs == null || pairs.length == 0) {
            return null;
        }
        HashMap nvMap = Maps.newHashMap();
        for (ManifestHeader.NameValuePair pair : pairs) {
            nvMap.put(pair.getName(), pair.getValue());
        }
        return nvMap;
    }

    public static class ParsedHeaderEntry {
        public final String path;
        public final Map<String, String> attributes;
        public final Map<String, String> directives;

        ParsedHeaderEntry(String path, Map<String, String> attributes, Map<String, String> directives) {
            this.path = path;
            this.attributes = attributes;
            this.directives = directives;
        }
    }

    public static class ParsedHeader {
        public final String name;
        public final Collection<ParsedHeaderEntry> entries;

        ParsedHeader(String name, Collection<ParsedHeaderEntry> entries) {
            this.name = name;
            this.entries = entries;
        }
    }
}

