/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.config;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.labs.plugins.quickreload.DirectoryTracker;
import com.atlassian.labs.plugins.quickreload.LifecycledComponent;
import com.atlassian.labs.plugins.quickreload.QrConfiguration;
import com.atlassian.labs.plugins.quickreload.StateManager;
import com.atlassian.labs.plugins.quickreload.config.BasicConfigFileReader;
import com.atlassian.labs.plugins.quickreload.config.PomConventionStrategy;
import com.atlassian.labs.plugins.quickreload.utils.Files;
import com.atlassian.labs.plugins.quickreload.utils.LogLeveller;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ConfigReader
implements LifecycledComponent {
    private static final Logger log = LogLeveller.setInfo(LoggerFactory.getLogger(ConfigReader.class));
    private static final String LEGACY_HOME_FILE = "/.quickreload/quickreload";
    private static final String HOME_FILE = "/.quickreload";
    private static final String QUICKRELOAD_TRACK = "quickreload.tracked";
    private static final String DOT_QUICKRELOAD = ".quickreload";
    private final DirectoryTracker directoryTracker;
    private final QrConfiguration qrConfiguration;
    private final StateManager stateManager;

    @Inject
    public ConfigReader(DirectoryTracker directoryTracker, QrConfiguration qrConfiguration, StateManager stateManager) {
        this.directoryTracker = directoryTracker;
        this.qrConfiguration = qrConfiguration;
        this.stateManager = stateManager;
    }

    @Override
    public void onStartup() {
        this.reReadConfiguration();
    }

    public void onRefresh() {
        this.reReadConfiguration();
    }

    private void reReadConfiguration() {
        this.runPomXmlConvention();
        File homeDotQuickReload = this.getConfigurationFile();
        this.readConfigFile(homeDotQuickReload, false);
        homeDotQuickReload = this.getLegacyConfigurationFile();
        this.readConfigFile(homeDotQuickReload, false);
        this.findLocalDotQuickReload();
        this.readSystemProperty();
        this.applyQrConfigChanges();
    }

    private void runPomXmlConvention() {
        PomConventionStrategy strategy = new PomConventionStrategy(Files.pwd());
        List<File> targetDirs = strategy.getTargetDirs();
        for (File dir : targetDirs) {
            this.directoryTracker.add(dir);
        }
    }

    public File getLegacyConfigurationFile() {
        return this.readHomeFile(LEGACY_HOME_FILE, false);
    }

    public File getConfigurationFile() {
        return this.readHomeFile(HOME_FILE, true);
    }

    private File readHomeFile(String homeFile, boolean create) {
        File userHome = this.getHomeDir();
        File configFile = new File(userHome, homeFile);
        if (create && !configFile.exists()) {
            this.touch(configFile);
        }
        return configFile;
    }

    private File getHomeDir() {
        return new File(System.getProperty("user.home"));
    }

    private void findLocalDotQuickReload() {
        Files.traverseUpLookingForFile(DOT_QUICKRELOAD, Files.pwd(), new Effect<File>(){

            public void apply(File dotQuickReload) {
                ConfigReader.this.readConfigFile(dotQuickReload, true);
            }
        });
    }

    private void applyQrConfigChanges() {
        boolean batchingCurrentState;
        boolean batchingDesiredState = this.qrConfiguration.getFlag("webresourcebatching", true);
        if (batchingDesiredState != (batchingCurrentState = this.stateManager.isBatchingEnabled())) {
            if (batchingDesiredState) {
                this.stateManager.enableBatching();
            } else {
                this.stateManager.disableBatching();
            }
        }
    }

    @Override
    public void onShutdown() {
    }

    private void readSystemProperty() {
        String[] dirs;
        String quickReloadDirs = StringUtils.defaultString((String)System.getProperty(QUICKRELOAD_TRACK));
        for (String entry : dirs = StringUtils.split((String)quickReloadDirs, (String)",")) {
            this.processDirectoryEntry((Option<File>)Option.some((Object)Files.pwd()), entry);
        }
    }

    private void touch(File trackedDirList) {
        try {
            Files.mkdirs(trackedDirList.getParentFile());
            FileUtils.touch((File)trackedDirList);
            FileWriter out = new FileWriter(trackedDirList);
            out.write("#\n# Add directories to this file, one on each line, and the quick reload support will monitor them\n# and automatically load them as soon as they are compiled and assembled.\n#\n# You can use -Dquickreload.dirs=dir1,dir2,dir3 on the JVM command line to also specify directories\n# to monitor.\n#\n");
            IOUtils.closeQuietly((Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readConfigFile(File configFile, boolean localMode) {
        Option interpretRelativeToDir = Option.some((Object)configFile.getParentFile());
        List<String> fileEntries = this.readConfigFileEntries(configFile);
        if (localMode && configFile.exists() && configFile.isFile() && fileEntries.size() == 0) {
            this.directoryTracker.add(configFile.getParentFile().getAbsolutePath(), (Option<File>)Option.none(), Collections.<String, String>emptyMap());
        }
        for (String entry : fileEntries) {
            this.processDirectoryEntry((Option<File>)interpretRelativeToDir, entry);
        }
    }

    private void processDirectoryEntry(Option<File> interpretRelativeToDir, String entry) {
        ConfigEntry configEntry = this.parseEntry(entry);
        if (configEntry.isQrConfigEntry()) {
            this.qrConfiguration.addConfiguration(configEntry.getQrConfigProperties());
        } else {
            String path = configEntry.path;
            Map<String, String> mapOfProperties = configEntry.getPathProperties();
            Option resourceEntry = Option.option((Object)mapOfProperties.get("resource"));
            if (resourceEntry.isDefined()) {
                this.directoryTracker.addResourceEntry(path, interpretRelativeToDir);
            } else if (path.startsWith("!")) {
                path = StringUtils.substringAfter((String)path, (String)"!").trim();
                this.directoryTracker.remove(path, interpretRelativeToDir);
            } else {
                this.directoryTracker.add(path, interpretRelativeToDir, mapOfProperties);
            }
        }
    }

    @VisibleForTesting
    ConfigEntry parseEntry(String entry) {
        if ((entry = StringUtils.trim((String)entry)).matches("^qr\\s*:.*")) {
            entry = StringUtils.substringAfter((String)entry, (String)":");
            Map<String, String> qrProperties = this.parseProperties(entry);
            return new ConfigEntry(null, Collections.<String, String>emptyMap(), qrProperties);
        }
        String path = StringUtils.trim((String)entry);
        String propertiesEntry = "";
        if (StringUtils.contains((String)entry, (char)':')) {
            path = StringUtils.trim((String)StringUtils.substringAfter((String)entry, (String)":"));
            propertiesEntry = StringUtils.substringBefore((String)entry, (String)":");
        }
        Map<String, String> properties = this.parseProperties(propertiesEntry);
        return new ConfigEntry(path, properties, Collections.<String, String>emptyMap());
    }

    private Map<String, String> parseProperties(String propertiesEntry) {
        if (StringUtils.isNotBlank((String)propertiesEntry)) {
            String[] values;
            HashMap properties = Maps.newHashMap();
            for (String value : values = StringUtils.split((String)propertiesEntry, (String)";")) {
                if (StringUtils.startsWith((String)(value = StringUtils.trim((String)value)), (String)"=")) continue;
                String[] keyValues = StringUtils.split((String)value, (String)"=");
                if (keyValues.length == 1 && StringUtils.isNotBlank((String)keyValues[0])) {
                    properties.put(StringUtils.trim((String)keyValues[0]), "true");
                }
                if (keyValues.length != 2 || !StringUtils.isNotBlank((String)keyValues[0])) continue;
                properties.put(StringUtils.trim((String)keyValues[0]), StringUtils.trim((String)keyValues[1]));
            }
            return properties;
        }
        return Collections.emptyMap();
    }

    private List<String> readConfigFileEntries(File configFile) {
        try {
            return new BasicConfigFileReader().readConfigFileEntries(configFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            log.info(String.format("Unable to read file %s.  No plugins will be automatically tracked", configFile));
        }
        return Collections.emptyList();
    }

    public static class ConfigEntry {
        private final String path;
        private final Map<String, String> pathProperties;
        private final Map<String, String> qrConfigProperties;

        public ConfigEntry(String path, Map<String, String> pathProperties, Map<String, String> qrConfigProperties) {
            this.path = path;
            this.pathProperties = pathProperties;
            this.qrConfigProperties = qrConfigProperties;
        }

        public boolean isQrConfigEntry() {
            return this.qrConfigProperties.size() > 0;
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, String> getPathProperties() {
            return this.pathProperties;
        }

        public Map<String, String> getQrConfigProperties() {
            return this.qrConfigProperties;
        }
    }
}

