/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload;

import com.atlassian.fugue.Option;
import com.atlassian.labs.plugins.quickreload.Properties;
import com.atlassian.labs.plugins.quickreload.utils.Files;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;

@Named
public class DirectoryTracker {
    public static final String PLUGIN_RESOURCE_DIRECTORIES = "plugin.resource.directories";
    public static final String RESOURCE_COLON = "resource:";
    private final Set<File> trackedDirs = new TreeSet<File>();
    private final Map<File, Map<String, String>> directoryProperties = new HashMap<File, Map<String, String>>();

    public Set<File> getTracked() {
        return Sets.newHashSet(this.trackedDirs);
    }

    public boolean isTracked(File directory) {
        return this.trackedDirs.contains(directory);
    }

    public DirectoryTracker remove(File trackedDir) {
        return this.remove(trackedDir.getAbsolutePath(), (Option<File>)Option.none());
    }

    public DirectoryTracker add(String directoryName) {
        return this.add(directoryName, (Option<File>)Option.none(), Collections.<String, String>emptyMap());
    }

    public DirectoryTracker add(File dir) {
        return this.add(dir.getAbsolutePath(), (Option<File>)Option.none(), Collections.<String, String>emptyMap());
    }

    public DirectoryTracker add(String directoryName, Option<File> parentDir, Map<String, String> properties) {
        File directory = Files.smooshNames((File)parentDir.getOrElse((Object)new File(".")), directoryName);
        File targetDir = Files.smooshNames(directory, "./target");
        File resourcesDir = Files.smooshNames(directory, "./src/main/resources");
        if (this.hasPomFile(directory) && Files.directoryExists(resourcesDir)) {
            this.trackedDirs.add(targetDir);
            this.directoryProperties.put(targetDir, properties);
            this.addResourceDir(resourcesDir);
        } else {
            this.trackedDirs.add(directory);
            this.directoryProperties.put(targetDir, properties);
        }
        return this;
    }

    public DirectoryTracker remove(String directoryName, Option<File> parentDir) {
        File directory = Files.smooshNames((File)parentDir.getOrElse((Object)new File(".")), directoryName);
        File targetDir = Files.smooshNames(directory, "./target");
        File resourcesDir = Files.smooshNames(directory, "./src/main/resources");
        if (this.hasPomFile(directory) && Files.directoryExists(resourcesDir)) {
            this.trackedDirs.remove(targetDir);
            this.directoryProperties.remove(targetDir);
            this.removeResourceDir(resourcesDir);
        } else {
            this.trackedDirs.remove(directory);
            this.directoryProperties.remove(targetDir);
        }
        return this;
    }

    private boolean hasPomFile(File directory) {
        File pomFile = Files.smooshNames(directory, "./pom.xml");
        return pomFile.exists() && !pomFile.isDirectory();
    }

    public void addResourceEntry(String dirName, Option<File> parentDir) {
        String newDirName = StringUtils.remove((String)dirName, (String)RESOURCE_COLON);
        if (parentDir.isDefined()) {
            this.addResourceDir(Files.smooshNames((File)parentDir.get(), newDirName));
        } else {
            this.addResourceDir(new File(newDirName));
        }
    }

    private void addResourceDir(File resourcesDir) {
        Set<String> alternateResourceDirs = this.getSystemResourceDirs();
        alternateResourceDirs.add(resourcesDir.getAbsolutePath());
        this.setSystemResourceDirs(alternateResourceDirs);
    }

    private void removeResourceDir(File resourcesDir) {
        Set<String> alternateResourceDirs = this.getSystemResourceDirs();
        alternateResourceDirs.remove(resourcesDir.getAbsolutePath());
        this.setSystemResourceDirs(alternateResourceDirs);
    }

    private Set<String> getSystemResourceDirs() {
        return Sets.newHashSet(Properties.getSystemPropertySplit(PLUGIN_RESOURCE_DIRECTORIES, ","));
    }

    private void setSystemResourceDirs(Set<String> alternateResourceDirs) {
        Properties.setSystemProperty(PLUGIN_RESOURCE_DIRECTORIES, alternateResourceDirs, ',');
    }
}

