/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.httpservice.resource;

import com.atlassian.labs.httpservice.ServletManager;
import com.atlassian.labs.httpservice.resource.OsgiResourceHolder;
import com.atlassian.plugin.servlet.PluginHttpRequestWrapper;
import com.atlassian.plugin.servlet.descriptors.BaseServletModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.servlet.util.DefaultPathMapper;
import com.atlassian.plugin.servlet.util.PathMapper;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.http.HttpContext;

public class ResourceFilter
implements Filter {
    private final Map<String, OsgiResourceHolder> resources;
    private final PathMapper pathMapper;
    private final ServletManager servletManager;

    public ResourceFilter(ServletManager servletManager) {
        this.servletManager = servletManager;
        this.resources = new ConcurrentHashMap<String, OsgiResourceHolder>();
        this.pathMapper = new DefaultPathMapper();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean handled = false;
        ServletModuleDescriptor descriptor = this.servletManager.guessContext(((HttpServletRequest)request).getPathInfo());
        PluginHttpRequestWrapper servletRequest = descriptor != null ? new PluginHttpRequestWrapper((HttpServletRequest)request, (BaseServletModuleDescriptor)descriptor) : (HttpServletRequest)request;
        for (String key : this.pathMapper.getAll(ResourceFilter.findPath(request))) {
            if (!this.resources.get(key).handle((ServletRequest)servletRequest, response)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        this.resources.clear();
    }

    public void addResource(String alias, String name, HttpContext osgiHttpContext) {
        OsgiResourceHolder holder = new OsgiResourceHolder(name, osgiHttpContext);
        String key = String.valueOf(holder.hashCode());
        String pattern = "/".equals(alias) ? "/*" : alias + "/*";
        this.pathMapper.put(key, pattern);
        this.resources.put(key, holder);
    }

    private static String findPath(ServletRequest request) {
        String target = ((HttpServletRequest)request).getPathInfo();
        if (target == null) {
            target = "";
        }
        if (!target.startsWith("/")) {
            target = target + "/" + target;
        }
        return target;
    }
}

