/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.httpservice;

import com.atlassian.labs.httpservice.HttpServiceImpl;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.servlet.ServletModuleManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    private static final Log log = LogFactory.getLog(Activator.class);
    private ServiceRegistration httpServiceFactory;

    public void start(BundleContext bundleContext) throws Exception {
        if (bundleContext.getServiceReference(ServletModuleManager.class.getName()) == null) {
            log.error((Object)"The servlet module manager isn't registered as a host component.  The HttpService can not be registered.");
        } else {
            this.httpServiceFactory = bundleContext.registerService(HttpService.class.getName(), (Object)new HttpServiceFactory(), null);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.httpServiceFactory != null) {
            this.httpServiceFactory.unregister();
        }
    }

    private static <T> T findService(BundleContext bundleContext, Class<T> type) {
        ServiceReference ref = bundleContext.getServiceReference(type.getName());
        if (ref == null) {
            throw new IllegalStateException("Unable to locate service of type " + type + ".");
        }
        return (T)bundleContext.getService(ref);
    }

    public class HttpServiceFactory
    implements ServiceFactory {
        public Object getService(Bundle bundle, ServiceRegistration registration) {
            BundleContext bundleContext = bundle.getBundleContext();
            PluginAccessor pluginAccessor = (PluginAccessor)Activator.findService(bundleContext, PluginAccessor.class);
            ServletModuleManager servletModuleManager = (ServletModuleManager)Activator.findService(bundleContext, ServletModuleManager.class);
            String key = OsgiHeaderUtil.getPluginKey((Bundle)bundle);
            HttpServiceImpl srv = new HttpServiceImpl(pluginAccessor.getPlugin(key), bundle, servletModuleManager);
            log.debug((Object)("** http service get:" + bundle + ", service: " + srv));
            return srv;
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            log.debug((Object)("** http service unget:" + bundle + ", service: " + service));
            ((HttpServiceImpl)service).unregisterAll();
        }
    }
}

