/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fastdev;

import com.atlassian.fastdev.AutoReloadFilter;
import com.atlassian.fastdev.maven.MavenTaskManager;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.File;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginReloader {
    private final Logger LOG = LoggerFactory.getLogger(AutoReloadFilter.class);
    private final ApplicationProperties applicationProperties;
    private final MavenTaskManager taskManager;

    public PluginReloader(ApplicationProperties applicationProperties, MavenTaskManager taskManager) {
        this.applicationProperties = applicationProperties;
        this.taskManager = taskManager;
    }

    public void pluginInstall(File root) {
        URI baseUri = URI.create(this.applicationProperties.getBaseUrl());
        int httpPort = baseUri.getPort();
        String contextPath = baseUri.getPath();
        File buildRoot = root.getParentFile().getParentFile();
        if (!buildRoot.isDirectory() || !new File(buildRoot, "pom.xml").exists()) {
            this.LOG.warn(buildRoot.getPath() + " does not contain pom.xml. Skipping");
        }
        for (MavenTaskManager.MavenTask task : this.taskManager.createTask(buildRoot, "resources:resources", "com.atlassian.maven.plugins:maven-amps-plugin:filter-plugin-descriptor", "compile", "com.atlassian.maven.plugins:maven-amps-plugin:copy-bundled-dependencies", "com.atlassian.maven.plugins:maven-amps-plugin:compress-resources", "com.atlassian.maven.plugins:maven-amps-plugin:generate-manifest", "com.atlassian.maven.plugins:maven-amps-plugin:jar", "com.atlassian.maven.plugins:maven-amps-plugin:install", "-Dhttp.port=" + httpPort, "-Dcontext.path=" + contextPath).right()) {
            this.LOG.info("Executing mvn process in " + buildRoot.getPath());
            task.start();
        }
    }
}

