package com.atlassian.fastdev.rest.resources;

import java.io.IOException;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import com.atlassian.fastdev.ReloadHandler;
import com.atlassian.fastdev.maven.MavenTaskManager;
import com.atlassian.fastdev.rest.FastdevUriBuilder;
import com.atlassian.fastdev.rest.representations.MavenTaskCollectionRepresentation;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;

import static com.google.common.base.Preconditions.checkNotNull;
import static javax.ws.rs.core.MediaType.APPLICATION_JSON;

@Path("/reload")
@AnonymousAllowed
public class ReloadResource
{
    private final MavenTaskManager taskManager;
    private final FastdevUriBuilder uriBuilder;
    private final ReloadHandler reloadHandler;

    public ReloadResource(MavenTaskManager taskManager, FastdevUriBuilder uriBuilder, ReloadHandler reloadHandler)
    {
        this.taskManager = checkNotNull(taskManager, "taskManager");
        this.uriBuilder = checkNotNull(uriBuilder, "uriBuilder");
        this.reloadHandler = checkNotNull(reloadHandler, "reloadHandler");
    }

    @POST
    @Produces(APPLICATION_JSON)
    public Response triggerReloadTask() throws IOException
    {
        for (String output : reloadHandler.reloadPlugins())
        {
            return Response.ok(new MavenTaskCollectionRepresentation(taskManager, uriBuilder)).build();
        }

        return Response.noContent().build();
    }
}

